# CPRI Demonstration Platform Generator. 2018.3
set valid 0
# Stay in while loop untill a valid option is given by the user
while {$valid == 0} {
  puts "1. Ultrascale KCU105 - up to 10.137Gb/s"
  puts "2. Ultrascale VCU108 - up to 24.330Gb/s with FEC"
  puts "3. Ultrascale ZCU102 - up to 12.165Gb/s"
  puts "4. Ultrascale VCU108 - up to 12.165Gb/s (Master/Slave)"
  puts "5. UltrascalePlus VCU118 - 24.330Gb/s only, with Hard FEC"
  puts -nonewline "Please select number of hardware demo to be generated: "
  flush stdout
  set hw_demo [gets stdin]

  # Switch case will ensure the project has selected the correct board
  switch $hw_demo {
    1 {
      puts "Selected Demo $hw_demo."
      set PROJ_NAME kcu105_hwdemo
      create_project -force $PROJ_NAME ./$PROJ_NAME -part xcku040-ffva1156-1-i
      set_property target_language VHDL [current_project]
      set valid 1
    }
    2 {
      puts "Selected Demo $hw_demo."
      set PROJ_NAME vcu108_sfec_hwdemo
      create_project -force $PROJ_NAME ./$PROJ_NAME -part xcvu095-ffva2104-2-e
      set_property target_language VHDL [current_project]
      set valid 1
    }
    3 {
      puts "Selected Demo $hw_demo."
      set PROJ_NAME zcu102_hwdemo
      create_project -force $PROJ_NAME ./$PROJ_NAME -part xczu9eg-ffvb1156-2-i
      set_property target_language VHDL [current_project]
      set valid 1
    }
    4 {
      puts "Selected Demo $hw_demo."
      set PROJ_NAME vcu108_ms_hwdemo
      create_project -force $PROJ_NAME ./$PROJ_NAME -part xcvu095-ffva2104-2-e
      set_property target_language VHDL [current_project]
      set valid 1
    }
    5 {
      puts "Selected Demo $hw_demo."
      set PROJ_NAME vcu118_hfec_hwdemo
      create_project -force $PROJ_NAME ./$PROJ_NAME -part xcvu9p-flga2104-2L-e
      set_property target_language VHDL [current_project]
      set valid 1
    }
    default {
      puts "Invalid selection please select again!"
      set valid 0
    }
  }
}

# Generate CPRI core
create_ip -name cpri -vendor xilinx.com -library ip -module_name cpri_0

switch $hw_demo {
  1 {
    set_property -dict [list CONFIG.Line_Rate {10.137G_and_under} CONFIG.Ref_Clk {307.20MHz} CONFIG.Use_GMII {true} CONFIG.AXI_ipif {true} CONFIG.SupportLevel {1} CONFIG.TransceiverControl {true} CONFIG.Aux_Clk_Rate {100.0} ] [get_ips cpri_0]
    }
  2 {
    set_property -dict [list CONFIG.Line_Rate {24.330G_and_under} CONFIG.Ref_Clk {245.76MHz} CONFIG.Use_GMII {true} CONFIG.AXI_ipif {true} CONFIG.SupportLevel {1} CONFIG.TransceiverControl {true} CONFIG.Aux_Clk_Rate {100.0} CONFIG.GT_Type {GTYE3} CONFIG.Use_FEC {true} ] [get_ips cpri_0]
    }
  3 {
    set_property -dict [list CONFIG.Line_Rate {12.165G_and_under} CONFIG.Ref_Clk {245.76MHz} CONFIG.Use_GMII {true} CONFIG.AXI_ipif {true} CONFIG.SupportLevel {1} CONFIG.TransceiverControl {true} CONFIG.Aux_Clk_Rate {100.0} CONFIG.GT_Type {GTHE4} CONFIG.GT_Location {X1Y12} ] [get_ips cpri_0]
    }
  4 {
    set_property -dict [list CONFIG.Line_Rate {12.165G_and_under} CONFIG.Ref_Clk {245.76MHz} CONFIG.Use_GMII {true} CONFIG.AXI_ipif {true} CONFIG.SupportLevel {0} CONFIG.TransceiverControl {true} CONFIG.Aux_Clk_Rate {100.0} CONFIG.GT_Type {GTYE3} CONFIG.GT_Location {X0Y10} ] [get_ips cpri_0]
    }
  5 {
    set_property -dict [list CONFIG.Line_Rate {24.330G_and_under} CONFIG.Ref_Clk {245.76MHz} CONFIG.Use_GMII {true} CONFIG.AXI_ipif {true} CONFIG.SupportLevel {1} CONFIG.TransceiverControl {true} CONFIG.Aux_Clk_Rate {100.0} CONFIG.GT_Type {GTYE4} CONFIG.Use_FEC {true} CONFIG.Use_Hard_FEC {true} CONFIG.Line_Rate_HFEC {24330.24_Mb/s_support} CONFIG.CMAC_Location {CMACE4_X0Y7} ] [get_ips cpri_0]
    }
  default {
    puts "Error should never reach this state"
  }
}

generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/cpri_0/cpri_0.xci]
create_ip_run [get_files -of_objects [get_fileset sources_1] ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/cpri_0/cpri_0.xci]
launch_run  cpri_0_synth_1
wait_on_run cpri_0_synth_1

# Generate CPRI core (Slave)
switch $hw_demo {
  4 {
    create_ip -name cpri -vendor xilinx.com -library ip -module_name cpri_1
    set_property -dict [list CONFIG.Line_Rate {12.165G_and_under} CONFIG.Ref_Clk {245.76MHz} CONFIG.Use_GMII {true} CONFIG.AXI_ipif {true} CONFIG.SupportLevel {0} CONFIG.TransceiverControl {true} CONFIG.Aux_Clk_Rate {100.0} CONFIG.GT_Type {GTYE3} CONFIG.GT_Location {X0Y11} ] [get_ips cpri_1]

    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/cpri_1/cpri_1.xci]
    create_ip_run [get_files -of_objects [get_fileset sources_1] ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/cpri_1/cpri_1.xci]
    launch_run  cpri_1_synth_1
    wait_on_run cpri_1_synth_1
    }
  default {
  }
}


#Open Example Design
open_example_project -force -dir ./$PROJ_NAME [get_ips cpri_0]
set_property enable_vhdl_2008 1 [current_project]

#Import common IIC Controller files
import_files -norecurse {./hwdemo_files/iic_controller_pkg.vhd ./hwdemo_files/iic_controller.vhd}

#Import common CPRI Package file
import_files -norecurse {./hwdemo_files/cpri_demo_pkg.vhd}

#Import files for Hardware Demo
switch $hw_demo {
  1 {
    import_files -fileset constrs_1 ./hwdemo_files/cpri_kcu105.xdc
    import_files -norecurse {./hwdemo_files/cpri_kcu105.vhd}
    }
  2 {
    import_files -fileset constrs_1 ./hwdemo_files/cpri_vcu108_64bit.xdc
    import_files -norecurse {./hwdemo_files/cpri_vcu108_64bit.vhd}
    }
  3 {
    import_files -fileset constrs_1 ./hwdemo_files/cpri_zcu102.xdc
    import_files -norecurse {./hwdemo_files/cpri_zcu102.vhd}
    }
  4 {
    import_files ./$PROJ_NAME/cpri_0_ex/imports/cpri_0_clocking.vhd
    import_files ./$PROJ_NAME/cpri_0_ex/imports/cpri_0_synchronizer.vhd
    import_files ./$PROJ_NAME/cpri_0_ex/imports/cpri_0_reset_synchronizer.vhd
    import_files ./$PROJ_NAME/cpri_0_ex/imports/cpri_0_gt_gtye3_common_wrapper.vhd
    import_files ./$PROJ_NAME/cpri_0_ex/imports/cpri_0_resets.vhd
    import_files ./$PROJ_NAME/cpri_0_ex/imports/cpri_0_tx_alignment.vhd
    import_files ./$PROJ_NAME/cpri_0_ex/imports/cpri_0_tx_sync.vhd
    import_files ./$PROJ_NAME/cpri_0_ex/imports/cpri_0_gt_common.v
    import_files ./$PROJ_NAME/cpri_0_ex/imports/gtwizard_ultrascale_v1_7_gtye3_common.v
    import_files -norecurse {./hwdemo_files/cpri_support/cpri_0_gt_rst_support.vhd}
    import_files -norecurse {./hwdemo_files/cpri_support/cpri_0_support.vhd}
    import_files -norecurse {./hwdemo_files/cpri_support/cpri_1_support.vhd}
    import_files -fileset constrs_1 ./hwdemo_files/cpri_vcu108_32bit_ms.xdc
    import_files -norecurse {./hwdemo_files/cpri_vcu108_32bit_ms.vhd}
    }
  5 {
    import_files -fileset constrs_1 ./hwdemo_files/cpri_vcu118_64bit.xdc
    import_files -norecurse {./hwdemo_files/cpri_vcu118_64bit.vhd}
    }
  default {
    puts "Error should never reach this state"
  }
}

#Import files from Example Design 
import_files ./$PROJ_NAME/cpri_0_ex/imports/iq_tx_gen.vhd ./$PROJ_NAME/cpri_0_ex/imports/tx_prbs.vhd ./$PROJ_NAME/cpri_0_ex/imports/vendor_stim.vhd ./$PROJ_NAME/cpri_0_ex/imports/iq_rx_chk.vhd ./$PROJ_NAME/cpri_0_ex/imports/hdlc_stim.vhd ./$PROJ_NAME/cpri_0_ex/imports/gmii_stim.vhd
update_compile_order -fileset sources_1

#Generate IIC Core
create_ip -name axi_iic -vendor xilinx.com -library ip -module_name axi_iic_0
set_property -dict [list CONFIG.AXI_ACLK_FREQ_MHZ {100} CONFIG.C_SCL_INERTIAL_DELAY {50} CONFIG.C_SDA_INERTIAL_DELAY {50} CONFIG.USE_BOARD_FLOW {false}] [get_ips axi_iic_0]
generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/axi_iic_0/axi_iic_0.xci]

#Generate Control VIO Core
switch $hw_demo {
  1 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_control
    set_property -dict [list CONFIG.C_NUM_PROBE_OUT {15} CONFIG.C_PROBE_IN0_WIDTH {32} CONFIG.C_PROBE_OUT2_WIDTH {12} CONFIG.C_PROBE_OUT3_WIDTH {32} CONFIG.C_PROBE_OUT7_INIT_VAL {0x1} CONFIG.C_PROBE_OUT8_INIT_VAL {0x1}] [get_ips vio_control]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_control/vio_control.xci]
    }
  2 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_control
    set_property -dict [list CONFIG.C_NUM_PROBE_OUT {21} CONFIG.C_PROBE_IN0_WIDTH {32} CONFIG.C_PROBE_OUT2_WIDTH {12} CONFIG.C_PROBE_OUT3_WIDTH {32} CONFIG.C_PROBE_OUT7_INIT_VAL {0x1} CONFIG.C_PROBE_OUT8_INIT_VAL {0x1}] [get_ips vio_control]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_control/vio_control.xci]
    }
  3 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_control
    set_property -dict [list CONFIG.C_NUM_PROBE_OUT {15} CONFIG.C_PROBE_IN0_WIDTH {32} CONFIG.C_PROBE_OUT2_WIDTH {12} CONFIG.C_PROBE_OUT3_WIDTH {32} CONFIG.C_PROBE_OUT7_INIT_VAL {0x1} CONFIG.C_PROBE_OUT8_INIT_VAL {0x1}] [get_ips vio_control]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_control/vio_control.xci]
    }
  4 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_control
    set_property -dict [list CONFIG.C_NUM_PROBE_OUT {14} CONFIG.C_PROBE_IN0_WIDTH {32} CONFIG.C_PROBE_OUT2_WIDTH {12} CONFIG.C_PROBE_OUT3_WIDTH {32} CONFIG.C_PROBE_OUT7_INIT_VAL {0x1} CONFIG.C_PROBE_OUT8_INIT_VAL {0x1}] [get_ips vio_control]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_control/vio_control.xci]
    }
  5 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_control
    set_property -dict [list CONFIG.C_NUM_PROBE_OUT {17} CONFIG.C_PROBE_IN0_WIDTH {32} CONFIG.C_PROBE_OUT2_WIDTH {12} CONFIG.C_PROBE_OUT3_WIDTH {32} CONFIG.C_PROBE_OUT7_INIT_VAL {0x1}] [get_ips vio_control]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_control/vio_control.xci]
    }
  default {
    puts "Error should never reach this state"
    }
}

#Generate Status VIO Core
switch $hw_demo {
  1 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_status 
    set_property -dict [list CONFIG.C_NUM_PROBE_IN {35} CONFIG.C_NUM_PROBE_OUT {0} CONFIG.C_PROBE_IN0_WIDTH {16} CONFIG.C_PROBE_IN1_WIDTH {16} CONFIG.C_PROBE_IN2_WIDTH {16} CONFIG.C_PROBE_IN3_WIDTH {16} CONFIG.C_PROBE_IN4_WIDTH {16} CONFIG.C_PROBE_IN5_WIDTH {16} CONFIG.C_PROBE_IN6_WIDTH {16} CONFIG.C_PROBE_IN7_WIDTH {16} CONFIG.C_PROBE_IN8_WIDTH {14} CONFIG.C_PROBE_IN9_WIDTH {18} CONFIG.C_PROBE_IN10_WIDTH {7} CONFIG.C_PROBE_IN20_WIDTH {5} CONFIG.C_PROBE_IN28_WIDTH {36} CONFIG.C_PROBE_IN33_WIDTH {16} CONFIG.C_PROBE_IN34_WIDTH {16}] [get_ips vio_status]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_status/vio_status.xci]
    }
  2 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_status
    set_property -dict [list CONFIG.C_NUM_PROBE_IN {35} CONFIG.C_NUM_PROBE_OUT {0} CONFIG.C_PROBE_IN0_WIDTH {16} CONFIG.C_PROBE_IN1_WIDTH {16} CONFIG.C_PROBE_IN2_WIDTH {16} CONFIG.C_PROBE_IN3_WIDTH {16} CONFIG.C_PROBE_IN4_WIDTH {16} CONFIG.C_PROBE_IN5_WIDTH {16} CONFIG.C_PROBE_IN6_WIDTH {16} CONFIG.C_PROBE_IN7_WIDTH {16} CONFIG.C_PROBE_IN8_WIDTH {14} CONFIG.C_PROBE_IN9_WIDTH {18} CONFIG.C_PROBE_IN10_WIDTH {7} CONFIG.C_PROBE_IN20_WIDTH {5} CONFIG.C_PROBE_IN28_WIDTH {36} CONFIG.C_PROBE_IN33_WIDTH {16} CONFIG.C_PROBE_IN34_WIDTH {16}] [get_ips vio_status]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_status/vio_status.xci]
    }
  3 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_status
    set_property -dict [list CONFIG.C_NUM_PROBE_IN {35} CONFIG.C_NUM_PROBE_OUT {0} CONFIG.C_PROBE_IN0_WIDTH {16} CONFIG.C_PROBE_IN1_WIDTH {16} CONFIG.C_PROBE_IN2_WIDTH {16} CONFIG.C_PROBE_IN3_WIDTH {16} CONFIG.C_PROBE_IN4_WIDTH {16} CONFIG.C_PROBE_IN5_WIDTH {16} CONFIG.C_PROBE_IN6_WIDTH {16} CONFIG.C_PROBE_IN7_WIDTH {16} CONFIG.C_PROBE_IN8_WIDTH {14} CONFIG.C_PROBE_IN9_WIDTH {18} CONFIG.C_PROBE_IN10_WIDTH {7} CONFIG.C_PROBE_IN20_WIDTH {5} CONFIG.C_PROBE_IN28_WIDTH {36} CONFIG.C_PROBE_IN33_WIDTH {16} CONFIG.C_PROBE_IN34_WIDTH {16}] [get_ips vio_status]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_status/vio_status.xci]
    }
  4 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_status
    set_property -dict [list CONFIG.C_NUM_PROBE_IN {35} CONFIG.C_NUM_PROBE_OUT {0} CONFIG.C_PROBE_IN0_WIDTH {16} CONFIG.C_PROBE_IN1_WIDTH {16} CONFIG.C_PROBE_IN2_WIDTH {16} CONFIG.C_PROBE_IN3_WIDTH {16} CONFIG.C_PROBE_IN4_WIDTH {16} CONFIG.C_PROBE_IN5_WIDTH {16} CONFIG.C_PROBE_IN6_WIDTH {16} CONFIG.C_PROBE_IN7_WIDTH {16} CONFIG.C_PROBE_IN8_WIDTH {14} CONFIG.C_PROBE_IN9_WIDTH {18} CONFIG.C_PROBE_IN10_WIDTH {7} CONFIG.C_PROBE_IN20_WIDTH {5} CONFIG.C_PROBE_IN28_WIDTH {36} CONFIG.C_PROBE_IN33_WIDTH {16} CONFIG.C_PROBE_IN34_WIDTH {16}] [get_ips vio_status]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_status/vio_status.xci]
    }
  5 {
    create_ip -name vio -vendor xilinx.com -library ip -module_name vio_status
    set_property -dict [list CONFIG.C_NUM_PROBE_IN {36} CONFIG.C_NUM_PROBE_OUT {0} CONFIG.C_PROBE_IN0_WIDTH {16} CONFIG.C_PROBE_IN1_WIDTH {16} CONFIG.C_PROBE_IN2_WIDTH {16} CONFIG.C_PROBE_IN3_WIDTH {16} CONFIG.C_PROBE_IN4_WIDTH {16} CONFIG.C_PROBE_IN5_WIDTH {16} CONFIG.C_PROBE_IN6_WIDTH {16} CONFIG.C_PROBE_IN7_WIDTH {16} CONFIG.C_PROBE_IN8_WIDTH {14} CONFIG.C_PROBE_IN9_WIDTH {18} CONFIG.C_PROBE_IN10_WIDTH {7} CONFIG.C_PROBE_IN20_WIDTH {5} CONFIG.C_PROBE_IN28_WIDTH {36} CONFIG.C_PROBE_IN33_WIDTH {16} CONFIG.C_PROBE_IN34_WIDTH {16} CONFIG.C_PROBE_IN35_WIDTH {16}] [get_ips vio_status]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/vio_status/vio_status.xci]
    }
  default {
    puts "Error should never reach this state"
    }
}

#Generate TX ILA
switch $hw_demo {
  1 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_0
    set_property -dict [list CONFIG.C_PROBE9_WIDTH {8} CONFIG.C_PROBE8_WIDTH {16} CONFIG.C_PROBE7_WIDTH {6} CONFIG.C_PROBE6_WIDTH {2} CONFIG.C_PROBE3_WIDTH {32} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {24}] [get_ips ila_0]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_0/ila_0.xci]
    }
  2 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_0
    set_property -dict [list CONFIG.C_PROBE9_WIDTH {8} CONFIG.C_PROBE8_WIDTH {16} CONFIG.C_PROBE7_WIDTH {6} CONFIG.C_PROBE6_WIDTH {2} CONFIG.C_PROBE3_WIDTH {64} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {24}] [get_ips ila_0]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_0/ila_0.xci]
    }
  3 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_0
    set_property -dict [list CONFIG.C_PROBE9_WIDTH {8} CONFIG.C_PROBE8_WIDTH {16} CONFIG.C_PROBE7_WIDTH {6} CONFIG.C_PROBE6_WIDTH {2} CONFIG.C_PROBE3_WIDTH {32} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {24}] [get_ips ila_0]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_0/ila_0.xci]
    }
  4 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_0
    set_property -dict [list CONFIG.C_PROBE9_WIDTH {8} CONFIG.C_PROBE8_WIDTH {16} CONFIG.C_PROBE7_WIDTH {6} CONFIG.C_PROBE6_WIDTH {2} CONFIG.C_PROBE3_WIDTH {32} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {24}] [get_ips ila_0]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_0/ila_0.xci]
    }
  5 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_0
    set_property -dict [list CONFIG.C_PROBE9_WIDTH {8} CONFIG.C_PROBE8_WIDTH {16} CONFIG.C_PROBE7_WIDTH {6} CONFIG.C_PROBE6_WIDTH {2} CONFIG.C_PROBE3_WIDTH {64} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {24}] [get_ips ila_0]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_0/ila_0.xci]
    }
  default {
    puts "Error should never reach this state"
    }
}

#Generate RX ILA
switch $hw_demo {
  1 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_1
    set_property -dict [list CONFIG.C_PROBE14_WIDTH {8} CONFIG.C_PROBE12_WIDTH {16} CONFIG.C_PROBE11_WIDTH {6} CONFIG.C_PROBE10_WIDTH {2} CONFIG.C_PROBE6_WIDTH {8} CONFIG.C_PROBE5_WIDTH {4} CONFIG.C_PROBE3_WIDTH {32} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {18}] [get_ips ila_1]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_1/ila_1.xci]
    }
  2 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_1
    set_property -dict [list CONFIG.C_PROBE14_WIDTH {8} CONFIG.C_PROBE12_WIDTH {16} CONFIG.C_PROBE11_WIDTH {6} CONFIG.C_PROBE10_WIDTH {2} CONFIG.C_PROBE6_WIDTH {15} CONFIG.C_PROBE5_WIDTH {4} CONFIG.C_PROBE3_WIDTH {64} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {18}] [get_ips ila_1]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_1/ila_1.xci]
    }
  3 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_1
    set_property -dict [list CONFIG.C_PROBE14_WIDTH {8} CONFIG.C_PROBE12_WIDTH {16} CONFIG.C_PROBE11_WIDTH {6} CONFIG.C_PROBE10_WIDTH {2} CONFIG.C_PROBE6_WIDTH {10} CONFIG.C_PROBE5_WIDTH {4} CONFIG.C_PROBE3_WIDTH {32} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {18}] [get_ips ila_1]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_1/ila_1.xci]
    }
  4 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_1
    set_property -dict [list CONFIG.C_PROBE14_WIDTH {8} CONFIG.C_PROBE12_WIDTH {16} CONFIG.C_PROBE11_WIDTH {6} CONFIG.C_PROBE10_WIDTH {2} CONFIG.C_PROBE6_WIDTH {10} CONFIG.C_PROBE5_WIDTH {4} CONFIG.C_PROBE3_WIDTH {32} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {18}] [get_ips ila_1]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_1/ila_1.xci]
    }
  5 {
    create_ip -name ila -vendor xilinx.com -library ip -module_name ila_1
    set_property -dict [list CONFIG.C_PROBE14_WIDTH {8} CONFIG.C_PROBE12_WIDTH {16} CONFIG.C_PROBE11_WIDTH {6} CONFIG.C_PROBE10_WIDTH {2} CONFIG.C_PROBE6_WIDTH {15} CONFIG.C_PROBE5_WIDTH {4} CONFIG.C_PROBE3_WIDTH {64} CONFIG.C_PROBE1_WIDTH {12} CONFIG.C_DATA_DEPTH {2048} CONFIG.C_NUM_OF_PROBES {18}] [get_ips ila_1]
    generate_target all [get_files  ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/ip/ila_1/ila_1.xci]
    }
  default {
    puts "Error should never reach this state"
    }
}


# Enable VHDL 2008 synthesis - CPRI Package
set_property file_type {VHDL 2008} [get_files ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/imports/hwdemo_files/cpri_demo_pkg.vhd]

# Enable VHDL 2008 synthesis - CPRI demo design
switch $hw_demo {
  1 {
    set_property file_type {VHDL 2008} [get_files ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/imports/hwdemo_files/cpri_kcu105.vhd]
    }
  2 {
    set_property file_type {VHDL 2008} [get_files ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/imports/hwdemo_files/cpri_vcu108_64bit.vhd]
    }
  3 {
    set_property file_type {VHDL 2008} [get_files ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/imports/hwdemo_files/cpri_zcu102.vhd]
    }
  4 {
    set_property file_type {VHDL 2008} [get_files ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/imports/hwdemo_files/cpri_vcu108_32bit_ms.vhd]
    }
  5 {
    set_property file_type {VHDL 2008} [get_files ./$PROJ_NAME/$PROJ_NAME.srcs/sources_1/imports/hwdemo_files/cpri_vcu118_64bit.vhd]
    }
  default {
    puts "Error should never reach this state"
    }
}

update_compile_order -fileset sim_1
update_compile_order -fileset sources_1
reset_run synth_1
launch_runs synth_1
wait_on_run synth_1

switch $hw_demo {
  2 {
    set_property STEPS.PLACE_DESIGN.ARGS.DIRECTIVE ExtraTimingOpt [get_runs impl_1]
    launch_runs impl_1
    wait_on_run impl_1
    launch_runs impl_1 -to_step write_bitstream
    }
  default {
    launch_runs impl_1
    wait_on_run impl_1
    launch_runs impl_1 -to_step write_bitstream
    }
}