# Title      : Example top level for CPRI design on KCU105
# Project    : CPRI
#---------------------------------------------------------------------
# File       : cpri_kcu105.xdc
# Author     : Xilinx
#---------------------------------------------------------------------
# Description:
#   This example design for CPRI is designed to be hosted on
#   the KCU105 Evalutation Board using Chipscope to provide
#   Control and Monitoring of the CPRI core.
#
#---------------------------------------------------------------------
# (c) Copyright 2004 - 2016 Xilinx, Inc. All rights reserved.
#
# This file contains confidential and proprietary information
# of Xilinx, Inc. and is protected under U.S. and
# international copyright and other intellectual property
# laws.
#
# DISCLAIMER
# This disclaimer is not a license and does not grant any
# rights to the materials distributed herewith. Except as
# otherwise provided in a valid license issued to you by
# Xilinx, and to the maximum extent permitted by applicable
# law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
# WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
# AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
# BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
# INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
# (2) Xilinx shall not be liable (whether in contract or tort,
# including negligence, or under any other theory of
# liability) for any loss or damage of any kind or nature
# related to, arising under or in connection with these
# materials, including for any direct, or any indirect,
# special, incidental, or consequential loss or damage
# (including loss of data, profits, goodwill, or any type of
# loss or damage suffered as a result of any action brought
# by a third party) even if such damage or loss was
# reasonably foreseeable or Xilinx had been advised of the
# possibility of the same.
#
# CRITICAL APPLICATIONS
# Xilinx products are not designed or intended to be fail-
# safe, or for use in any application requiring fail-safe
# performance, such as life-support or safety devices or
# systems, Class III medical devices, nuclear facilities,
# applications related to the deployment of airbags, or any
# other applications that could lead to death, personal
# injury, or severe property or environmental damage
# (individually and collectively, "Critical
# Applications"). Customer assumes the sole risk and
# liability of any use of Xilinx products in Critical
# Applications, subject only to applicable laws and
# regulations governing limitations on product liability.
#
# THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
# PART OF THIS FILE AT ALL TIMES.
#-----------------------------------------------------------------------

####### Main Clock constraints #######

# 300MHz System clock constraint
# The auxiliary clock is derived from this and runs at 100MHz
create_clock -name refclk -period 3.255 [get_ports refclk_p]
create_clock -name clk300 -period 3.333 [get_ports clk300_p]

create_generated_clock -name hires_clk [get_pins -filter {REF_PIN_NAME =~ CLKOUT0} -of [get_cells -hier -filter {name =~ mmcm_i}]]
create_generated_clock -name aux_clk   [get_pins -filter {REF_PIN_NAME =~ CLKOUT1} -of [get_cells -hier -filter {name =~ mmcm_i}]]
create_generated_clock -name clk10     [get_pins -filter {REF_PIN_NAME =~ CLKOUT2} -of [get_cells -hier -filter {name =~ mmcm_i}]]
create_generated_clock -name eth_clk   [get_pins -filter {REF_PIN_NAME =~ CLKOUT3} -of [get_cells -hier -filter {name =~ mmcm_i}]]

####### False and Reset paths #######

# External reset Pushbutton
set_false_path -from [get_ports pb_reset]
set_false_path -from [all_registers -clock clk10]

# Clock crossing constraints for the data generators and monitors in the example design top level
set_false_path -from [get_clocks aux_clk] -to [get_cells {iq_rx_chk_enable_eth_reg[*][0]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {iq_rx_chk_enable_clk_reg[*][0]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {vendor_tx_rx_i/vendor_tx_data_reg[*]}]
set_false_path -from [get_cells {iq_rx_chk_i/error_count_i_reg[*]}]    -to [get_clocks aux_clk]
set_false_path -from [get_cells {iq_rx_chk_i/frame_count_i_reg[*]}]    -to [get_clocks aux_clk]
set_false_path -from [get_cells {vendor_tx_rx_i/error_count_i_reg[*]}] -to [get_clocks aux_clk]
set_false_path -from [get_cells {vendor_tx_rx_i/word_count_i_reg[*]}]  -to [get_clocks aux_clk]
set_false_path -from [get_cells {hdlc_tx_rx_i/error_count_i_reg[*]}]   -to [get_clocks aux_clk]
set_false_path -from [get_cells {hdlc_tx_rx_i/bit_count_i_reg[*]}]     -to [get_clocks aux_clk]
set_false_path -to   [get_cells {gmii_tx_rx_i/tx_eth_half_r_reg*}]

# Constraint to ignore clock crossing between the managment and ethernet clocks
set_false_path -from [get_clocks aux_clk] -to [get_clocks eth_clk]
set_false_path -from [get_clocks eth_clk] -to [get_clocks aux_clk]

# Constraint to ignore clock crossing synchronisers on stat_speed from managment clock to txusrclk & recclk
set_false_path -from [get_clocks aux_clk] -to [get_cells {stat_speed_recclk_reg[0][*]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {stat_speed_clk_reg[0][*]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {stat_code_clk_reg[0][*]}]

# Signals sampled on the ILA but are sourced in the ethernet clock domain
set_false_path -from [get_clocks eth_clk] -to [get_cells -hier -filter {name =~ *i_ila_tx/U0/ila_core_inst* && IS_SEQUENTIAL}]
set_false_path -from [get_clocks eth_clk] -to [get_cells -hier -filter {name =~ *i_ila_rx/U0/ila_core_inst* && IS_SEQUENTIAL}]

# Signals sampled on the ILA but are sourced in the management clock domain
set_false_path -from [get_clocks aux_clk] -to [get_cells -hier -filter {name =~ *i_ila_tx/U0/ila_core_inst* && IS_SEQUENTIAL}]
set_false_path -from [get_clocks aux_clk] -to [get_cells -hier -filter {name =~ *i_ila_rx/U0/ila_core_inst* && IS_SEQUENTIAL}]
set_false_path -from [get_clocks aux_clk] -to [get_cells -hier -filter {name =~ *i_vio_control/inst* && IS_SEQUENTIAL}]

set_false_path -from [get_cells -hier -filter {name =~ *i_vio_control/inst/PROBE_OUT_ALL_INST/G_PROBE_OUT[*].PROBE_OUT0_INST/Probe_out_reg* && IS_SEQUENTIAL}]
set_false_path -to   [get_cells -hier -filter {name =~ *i_vio_status/inst/PROBE_IN_INST/probe_in_reg_reg* && IS_SEQUENTIAL}]
set_false_path -to   [get_cells -hier -filter {name =~ *i_ila_tx/U0/* && IS_SEQUENTIAL}]
set_false_path -to   [get_cells -hier -filter {name =~ *i_ila_rx/U0/* && IS_SEQUENTIAL}]

####### Placement constraints #######

create_pblock cpri_core
add_cells_to_pblock [get_pblocks cpri_core] [list [get_cells cpri_block_i/U0/cpri_block_i/cpri_i/*]]
add_cells_to_pblock [get_pblocks cpri_core] [list [get_cells iq_tx_gen_i/*]]
add_cells_to_pblock [get_pblocks cpri_core] [list [get_cells iq_rx_chk_i/*]]
add_cells_to_pblock [get_pblocks cpri_core] [list [get_cells hdlc_tx_rx_i/*]]
add_cells_to_pblock [get_pblocks cpri_core] [list [get_cells vendor_tx_rx_i/*]]
add_cells_to_pblock [get_pblocks cpri_core] [list [get_cells gmii_tx_rx_i/*]]
resize_pblock [get_pblocks cpri_core] -add {CLOCKREGION_X3Y2:CLOCKREGION_X3Y2}

# To connect GTHE3 to the SFP0 module use the following serial port placement constraints on bank 226.
# Also drive SFP0 tx disable low.
#set_property LOC GTHE3_CHANNEL_X0Y10 [get_cells cpri_block_i/U0/cpri_block_i/gt_and_clocks_i/cpri_0_gt_i/inst/gen_gtwizard_gthe3_top.cpri_0_gt_gtwizard_gthe3_inst/gen_gtwizard_gthe3.gen_channel_container[*].gen_enabled_channel.gthe3_channel_wrapper_inst/channel_inst/gthe3_channel_gen.gen_gthe3_channel_inst[0].GTHE3_CHANNEL_PRIM_INST]
#set_property PACKAGE_PIN U4       [get_ports  txp]
#set_property PACKAGE_PIN U3       [get_ports  txn]
#set_property PACKAGE_PIN T2       [get_ports  rxp]
#set_property PACKAGE_PIN T1       [get_ports  rxn]
#set_property PACKAGE_PIN AL8      [get_ports  sfp0_tx_disable]
#set_property IOSTANDARD  LVCMOS18 [get_ports  sfp0_tx_disable]

####### Pinout constraints for KCU105 #######

# To connect GTHE3 to the SMA connectors use the following serial port placement constraints on bank 226.
set_property LOC GTHE3_CHANNEL_X0Y11 [get_cells cpri_block_i/U0/cpri_block_i/gt_and_clocks_i/cpri_0_gt_i/inst/gen_gtwizard_gthe3_top.cpri_0_gt_gtwizard_gthe3_inst/gen_gtwizard_gthe3.gen_channel_container[*].gen_enabled_channel.gthe3_channel_wrapper_inst/channel_inst/gthe3_channel_gen.gen_gthe3_channel_inst[0].GTHE3_CHANNEL_PRIM_INST]
set_property PACKAGE_PIN R4       [get_ports  txp]
set_property PACKAGE_PIN R3       [get_ports  txn]
set_property PACKAGE_PIN P2       [get_ports  rxp]
set_property PACKAGE_PIN P1       [get_ports  rxn]

# Sys Clk - 300 MHz oscillator
set_property PACKAGE_PIN AK17     [get_ports  clk300_p]
set_property PACKAGE_PIN AK16     [get_ports  clk300_n]
set_property IOSTANDARD  LVDS     [get_ports  clk300_p]
set_property IOSTANDARD  LVDS     [get_ports  clk300_n]

# Output clock to Si5328 Multiplier/Jitter Attenuator
# These pins are routed to the on-board clock clean up PLL. If the
# design is being targetted to a revision A KCU105 then these constraints
# should be commented out, along with the recclkout_gen ODDR in the VHDL.
set_property PACKAGE_PIN AG11           [get_ports  clk_si5326_p]
set_property PACKAGE_PIN AH11           [get_ports  clk_si5326_n]
set_property IOSTANDARD  DIFF_HSTL_I_18 [get_ports  clk_si5326_p]
set_property IOSTANDARD  DIFF_HSTL_I_18 [get_ports  clk_si5326_n]

# GT Reference clock sourced by Si5328 Multiplier/Jitter Attenuator, bank 227.
set_property PACKAGE_PIN P6       [get_ports  refclk_p]
set_property PACKAGE_PIN P5       [get_ports  refclk_n]

# For KCU105 Rev A boards use E12 for clk_sel, all others use F12.
set_property PACKAGE_PIN F12      [get_ports  clk_sel]
set_property IOSTANDARD  LVCMOS18 [get_ports  clk_sel]

# Resets for Si5328 and  TCA9548 I2C switch
set_property PACKAGE_PIN K23      [get_ports  si5326_rst_n]
set_property PACKAGE_PIN AP10     [get_ports  iic_mux_rst_n]
set_property IOSTANDARD  LVCMOS18 [get_ports  si5326_rst_n]
set_property IOSTANDARD  LVCMOS18 [get_ports  iic_mux_rst_n]

# Enables FPGA Fan
set_property PACKAGE_PIN AJ9      [get_ports  fan_on]
set_property IOSTANDARD  LVCMOS18 [get_ports  fan_on]

# GPIO LEDs
# For KCU105 Rev A boards use P25 for LED0, for all others use AP8.
#set_property PACKAGE_PIN P25     [get_ports  leds[0]]
set_property PACKAGE_PIN AP8      [get_ports  leds[0]]
set_property PACKAGE_PIN H23      [get_ports  leds[1]]
set_property PACKAGE_PIN P20      [get_ports  leds[2]]
set_property PACKAGE_PIN P21      [get_ports  leds[3]]
set_property PACKAGE_PIN N22      [get_ports  leds[4]]
set_property PACKAGE_PIN M22      [get_ports  leds[5]]
set_property PACKAGE_PIN R23      [get_ports  leds[6]]
set_property PACKAGE_PIN P23      [get_ports  leds[7]]
set_property IOSTANDARD  LVCMOS18 [get_ports  leds[0]]
set_property IOSTANDARD  LVCMOS18 [get_ports  leds[1]]
set_property IOSTANDARD  LVCMOS18 [get_ports  leds[2]]
set_property IOSTANDARD  LVCMOS18 [get_ports  leds[3]]
set_property IOSTANDARD  LVCMOS18 [get_ports  leds[4]]
set_property IOSTANDARD  LVCMOS18 [get_ports  leds[5]]
set_property IOSTANDARD  LVCMOS18 [get_ports  leds[6]]
set_property IOSTANDARD  LVCMOS18 [get_ports  leds[7]]

# Reset Pushbutton - Centre PB (SW7)
set_property PACKAGE_PIN AE10     [get_ports  pb_reset]
set_property IOSTANDARD  LVCMOS18 [get_ports  pb_reset]

# Clock Monitor Outputs on SMAs J36 (core_clk_mon) and J37 (clk_si5326_mon)
set_property PACKAGE_PIN H27      [get_ports  core_clk_mon]
set_property PACKAGE_PIN G27      [get_ports  clk_si5326_mon]
set_property IOSTANDARD  LVCMOS18 [get_ports  core_clk_mon]
set_property IOSTANDARD  LVCMOS18 [get_ports  clk_si5326_mon]

# IIC
set_property PACKAGE_PIN J25      [get_ports  iic_sda]
set_property PACKAGE_PIN J24      [get_ports  iic_scl]
set_property IOSTANDARD  LVCMOS18 [get_ports  iic_sda]
set_property IOSTANDARD  LVCMOS18 [get_ports  iic_scl]
