--------------------------------------------------------------------------
-- Title : Shared transceiver GT_COMMON block
-- Project : CPRI
--------------------------------------------------------------------------
-- File : cpri_gt_rst_support.vhd
--------------------------------------------------------------------------
-- 
-- This file contains confidential and proprietary information
-- of Xilinx, Inc. and is protected under U.S. and
-- international copyright and other intellectual property
-- laws.
-- 
-- DISCLAIMER
-- This disclaimer is not a license and does not grant any
-- rights to the materials distributed herewith. Except as
-- otherwise provided in a valid license issued to you by
-- Xilinx, and to the maximum extent permitted by applicable
-- law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
-- WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
-- AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
-- BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
-- INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
-- (2) Xilinx shall not be liable (whether in contract or tort,
-- including negligence, or under any other theory of
-- liability) for any loss or damage of any kind or nature
-- related to, arising under or in connection with these
-- materials, including for any direct, or any indirect,
-- special, incidental, or consequential loss or damage
-- (including loss of data, profits, goodwill, or any type of
-- loss or damage suffered as a result of any action brought
-- by a third party) even if such damage or loss was
-- reasonably foreseeable or Xilinx had been advised of the
-- possibility of the same.
-- 
-- CRITICAL APPLICATIONS
-- Xilinx products are not designed or intended to be fail-
-- safe, or for use in any application requiring fail-safe
-- performance, such as life-support or safety devices or
-- systems, Class III medical devices, nuclear facilities,
-- applications related to the deployment of airbags, or any
-- other applications that could lead to death, personal
-- injury, or severe property or environmental damage
-- (individually and collectively, "Critical
-- Applications"). Customer assumes the sole risk and
-- liability of any use of Xilinx products in Critical
-- Applications, subject only to applicable laws and
-- regulations governing limitations on product liability.
-- 
-- THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
-- PART OF THIS FILE AT ALL TIMES. 
--------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;

library unisim;
use unisim.vcomponents.all;

library cpri_v8_8_2;
use cpri_v8_8_2.all;

entity cpri_0_gt_rst_support is
	port (
    -- Clocks
    refclk				  : in  std_logic;
    aux_clk					: in  std_logic;
    -- Control
    reset       		: in  std_logic;
    qpll0_pd        : in  std_logic;
    qpll1_pd        : in  std_logic;
    qpll_select     : in  std_logic;
    speed_select    : in  std_logic_vector(9 downto 0);
    -- GT Common Ports
    qpll0clk_out    : out std_logic;
    qpll0refclk_out : out std_logic;
    qpll1clk_out    : out std_logic;
    qpll1refclk_out : out std_logic;
    qpll0lock_out   : out std_logic;
    qpll1lock_out   : out std_logic;
    gt_qplllock     : out std_logic );
end cpri_0_gt_rst_support;

architecture rtl of cpri_0_gt_rst_support is

  -----------------------------------------------------------------------------
  -- Signals Declaration
  -----------------------------------------------------------------------------
  signal pll_reset        : std_logic;
  signal common_qplllock0 : std_logic;
  signal common_qplllock1 : std_logic;

  -----------------------------------------------------------------------------
  -- Component Declarations
  -----------------------------------------------------------------------------
  component cpri_0_resets is
  port (
    aux_clk     : in  std_logic;
    reset       : in  std_logic;
    qpll_reset  : out std_logic);
  end component;

  component cpri_0_gt_gtye3_common_wrapper is
  generic (
    SIM_RESET_SPEEDUP    : string  := "false"; -- Set to "true" to speed up sim reset
    SIM_VERSION          : string  := "4.0");
  port (
    GTREFCLK0_IN          : in  std_logic;
    QPLL0RESET_IN         : in  std_logic;
    QPLL0LOCKDETCLK_IN    : in  std_logic;
    QPLL0PD_IN            : in  std_logic;
    QPLL0LOCK_OUT         : out std_logic;
    QPLL0OUTCLK_OUT       : out std_logic;
    QPLL0OUTREFCLK_OUT    : out std_logic;
    QPLL1RESET_IN         : in  std_logic;
    QPLL1LOCKDETCLK_IN    : in  std_logic;
    QPLL1PD_IN            : in  std_logic;
    QPLL1LOCK_OUT         : out std_logic;
    QPLL1OUTCLK_OUT       : out std_logic;
    QPLL1OUTREFCLK_OUT    : out std_logic;
    speed_select          : in  std_logic_vector(9 downto 0) );
  end component;

begin

  -----------------------------------------------------------------------------
	-- Instantiate GT COMMON reset
  -----------------------------------------------------------------------------
	cpri_shared_resets_i : cpri_0_resets
  port map (
    aux_clk     => aux_clk,
    reset       => reset,
    qpll_reset  => pll_reset
  );

  -----------------------------------------------------------------------------
  -- Instantiate Common GT Module
  -----------------------------------------------------------------------------
  cpri_gt_common_i : cpri_0_gt_gtye3_common_wrapper
  generic map (
    SIM_VERSION => "4.0")
  port map (
    GTREFCLK0_IN            => refclk,
    QPLL0RESET_IN           => pll_reset,    
    QPLL0LOCKDETCLK_IN      => aux_clk,
    QPLL1RESET_IN           => pll_reset,    
    QPLL1LOCKDETCLK_IN      => aux_clk, 
    QPLL0PD_IN              => qpll0_pd,
    QPLL1PD_IN              => qpll1_pd,
    QPLL0LOCK_OUT           => common_qplllock0,
    QPLL0OUTCLK_OUT         => qpll0clk_out,
    QPLL0OUTREFCLK_OUT      => qpll0refclk_out,
    QPLL1LOCK_OUT           => common_qplllock1,
    QPLL1OUTCLK_OUT         => qpll1clk_out,
    QPLL1OUTREFCLK_OUT      => qpll1refclk_out,
    speed_select            => speed_select
  );

  -----------------------------------------------------------------------------
  -- Assign outputs
  -----------------------------------------------------------------------------
  qpll0lock_out <= common_qplllock0;
  qpll1lock_out <= common_qplllock1;
  gt_qplllock   <= common_qplllock0 when qpll_select = '0' else
                   common_qplllock1;

end rtl;