# Title      : Example top level for CPRI design on VCU108
# Project    : CPRI
#---------------------------------------------------------------------
# File       : cpri_vcu108.xdc
# Author     : Xilinx
#---------------------------------------------------------------------
# Description:
#   This example design for CPRI is designed to be hosted on
#   the VCU108 Evalutation Board using Chipscope to provide
#   Control and Monitoring of the CPRI core.
#
#---------------------------------------------------------------------
# (c) Copyright 2004 - 2016 Xilinx, Inc. All rights reserved.
#
# This file contains confidential and proprietary information
# of Xilinx, Inc. and is protected under U.S. and
# international copyright and other intellectual property
# laws.
#
# DISCLAIMER
# This disclaimer is not a license and does not grant any
# rights to the materials distributed herewith. Except as
# otherwise provided in a valid license issued to you by
# Xilinx, and to the maximum extent permitted by applicable
# law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
# WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
# AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
# BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
# INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
# (2) Xilinx shall not be liable (whether in contract or tort,
# including negligence, or under any other theory of
# liability) for any loss or damage of any kind or nature
# related to, arising under or in connection with these
# materials, including for any direct, or any indirect,
# special, incidental, or consequential loss or damage
# (including loss of data, profits, goodwill, or any type of
# loss or damage suffered as a result of any action brought
# by a third party) even if such damage or loss was
# reasonably foreseeable or Xilinx had been advised of the
# possibility of the same.
#
# CRITICAL APPLICATIONS
# Xilinx products are not designed or intended to be fail-
# safe, or for use in any application requiring fail-safe
# performance, such as life-support or safety devices or
# systems, Class III medical devices, nuclear facilities,
# applications related to the deployment of airbags, or any
# other applications that could lead to death, personal
# injury, or severe property or environmental damage
# (individually and collectively, "Critical
# Applications"). Customer assumes the sole risk and
# liability of any use of Xilinx products in Critical
# Applications, subject only to applicable laws and
# regulations governing limitations on product liability.
#
# THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
# PART OF THIS FILE AT ALL TIMES.
#-----------------------------------------------------------------------

####### Main Clock constraints #######

# 300MHz System clock constraint
# The auxiliary clock is derived from this and runs at 100MHz
create_clock -name refclk_m -period 4.069 [get_ports refclk_m_p]
create_clock -name refclk_s -period 4.069 [get_ports refclk_s_p]
create_clock -name clk300   -period 3.333 [get_ports clk300_p]

create_generated_clock -name hires_clk [get_pins -filter {REF_PIN_NAME =~ CLKOUT0} -of [get_cells -hier -filter {name =~ mmcm_i}]]
create_generated_clock -name aux_clk   [get_pins -filter {REF_PIN_NAME =~ CLKOUT1} -of [get_cells -hier -filter {name =~ mmcm_i}]]
create_generated_clock -name clk10     [get_pins -filter {REF_PIN_NAME =~ CLKOUT2} -of [get_cells -hier -filter {name =~ mmcm_i}]]
create_generated_clock -name eth_clk   [get_pins -filter {REF_PIN_NAME =~ CLKOUT3} -of [get_cells -hier -filter {name =~ mmcm_i}]]

####### False and Reset paths #######

# Clock crossing constraints for the data generators and monitors in the example design top level
set_false_path -from [get_clocks aux_clk] -to [get_cells {cpri_gen_i[*].iq_rx_chk_enable_eth_reg[*][0]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {cpri_gen_i[*].iq_rx_chk_enable_clk_reg[*][0]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {cpri_gen_i[*].vendor_tx_rx_i/vendor_tx_data_reg[*]}]
set_false_path -from [get_cells {cpri_gen_i[*].iq_rx_chk_i/error_count_i_reg[*]}]       -to [get_clocks aux_clk]
set_false_path -from [get_cells {cpri_gen_i[*].iq_rx_chk_i/frame_count_i_reg[*]}]       -to [get_clocks aux_clk]
set_false_path -from [get_cells {cpri_gen_i[*].iq_rx_chk_i/nodebfn_rx_nr_store_reg[*]}] -to [get_clocks aux_clk]
set_false_path -from [get_cells {cpri_gen_i[*].vendor_tx_rx_i/error_count_i_reg[*]}]    -to [get_clocks aux_clk]
set_false_path -from [get_cells {cpri_gen_i[*].vendor_tx_rx_i/word_count_i_reg[*]}]     -to [get_clocks aux_clk]
set_false_path -from [get_cells {cpri_gen_i[*].hdlc_tx_rx_i/error_count_i_reg[*]}]      -to [get_clocks aux_clk]
set_false_path -from [get_cells {cpri_gen_i[*].hdlc_tx_rx_i/bit_count_i_reg[*]}]        -to [get_clocks aux_clk]
set_false_path -to   [get_cells {cpri_gen_i[*].gmii_tx_rx_i/tx_eth_half_r_reg*}]
set_false_path -from [get_cells {cpri_gen_i[*].gmii_tx_rx_i/rx_error_counter_reg[*]}]   -to [get_clocks aux_clk]
set_false_path -from [get_cells {cpri_gen_i[*].gmii_tx_rx_i/tx_frame_counter_reg[*]}]   -to [get_clocks aux_clk]
set_false_path -from [get_cells {cpri_gen_i[*].gmii_tx_rx_i/rx_frame_counter_reg[*]}]   -to [get_clocks aux_clk]

# Constraint to ignore clock crossing synchronisers on stat_speed from managment clock to txusrclk & recclk
set_false_path -from [get_clocks aux_clk] -to [get_cells {cpri_gen_i[*].stat_speed_recclk_reg[*][0][*]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {cpri_gen_i[*].stat_speed_clk_reg[*][0][*]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {cpri_gen_i[*].stat_code_clk_reg[*][0][*]}]

# Constraint to ignore clock crossing between the managment and ethernet clocks
set_false_path -from [get_clocks aux_clk] -to [get_clocks eth_clk]
set_false_path -from [get_clocks eth_clk] -to [get_clocks aux_clk]

# Signals sampled on the ILA but are sourced in the ethernet clock domain
set_false_path -from [get_clocks eth_clk] -to [get_cells -hier -filter {name =~ *i_ila_tx/U0/ila_core_inst* && IS_SEQUENTIAL}]
set_false_path -from [get_clocks eth_clk] -to [get_cells -hier -filter {name =~ *i_ila_rx/U0/ila_core_inst* && IS_SEQUENTIAL}]

# Signals sampled on the ILA but are sourced in the management clock domain
set_false_path -from [get_clocks aux_clk] -to [get_cells -hier -filter {name =~ *i_ila_tx/U0/ila_core_inst* && IS_SEQUENTIAL}]
set_false_path -from [get_clocks aux_clk] -to [get_cells -hier -filter {name =~ *i_ila_rx/U0/ila_core_inst* && IS_SEQUENTIAL}]
set_false_path -from [get_clocks aux_clk] -to [get_cells -hier -filter {name =~ *i_vio_control/inst* && IS_SEQUENTIAL}]

set_false_path -from [get_cells -hier -filter {name =~ *i_vio_control/inst/PROBE_OUT_ALL_INST/G_PROBE_OUT[*].PROBE_OUT0_INST/Probe_out_reg* && IS_SEQUENTIAL}]
set_false_path -to   [get_cells -hier -filter {name =~ *i_vio_status/inst/PROBE_IN_INST/probe_in_reg_reg* && IS_SEQUENTIAL}]
set_false_path -to   [get_cells -hier -filter {name =~ *i_ila_tx/U0/* && IS_SEQUENTIAL}]
set_false_path -to   [get_cells -hier -filter {name =~ *i_ila_rx/U0/* && IS_SEQUENTIAL}]

# External reset Pushbutton
set_false_path -from [get_ports pb_reset]
set_false_path -from [all_registers -clock clk10]

####### Placement constraints #######
# These constraints are for the xcvu095-ffva2104-2-e part.

####### Pinout constraints for VCU108 #######

# Bullseye GTY connectors
set_property PACKAGE_PIN AT42 [get_ports txp_m]
set_property PACKAGE_PIN AT43 [get_ports txn_m]
set_property PACKAGE_PIN AR45 [get_ports rxp_m]
set_property PACKAGE_PIN AR46 [get_ports rxn_m]

set_property PACKAGE_PIN AP42 [get_ports txp_s]
set_property PACKAGE_PIN AP43 [get_ports txn_s]
set_property PACKAGE_PIN AN45 [get_ports rxp_s]
set_property PACKAGE_PIN AN46 [get_ports rxn_s]

# Sys Clk - 300 MHz oscillator
set_property PACKAGE_PIN G31       [get_ports  clk300_p]
set_property PACKAGE_PIN F31       [get_ports  clk300_n]
set_property IOSTANDARD  LVDS      [get_ports  clk300_p]
set_property IOSTANDARD  LVDS      [get_ports  clk300_n]

# Output clock to Si5328 Multiplier/Jitter Attenuator
set_property PACKAGE_PIN AG34      [get_ports  clk_si5328_p]
set_property PACKAGE_PIN AH35      [get_ports  clk_si5328_n]
set_property IOSTANDARD  LVDS      [get_ports  clk_si5328_p]
set_property IOSTANDARD  LVDS      [get_ports  clk_si5328_n]

# Master core GT reference clock sourced by Si570 Programmable Oscillator
set_property PACKAGE_PIN AF38      [get_ports  refclk_m_p]
set_property PACKAGE_PIN AF39      [get_ports  refclk_m_n]

# Slave core GT Reference clock sourced by Si5328 Multiplier/Jitter Attenuator
set_property PACKAGE_PIN AD38      [get_ports  refclk_s_p]
set_property PACKAGE_PIN AD39      [get_ports  refclk_s_n]

# Resets for Si5328 and TCA9548 I2C switch
set_property PACKAGE_PIN AN24      [get_ports  si5328_rst_n]
set_property PACKAGE_PIN AM23      [get_ports  iic_mux_rst_n]
set_property IOSTANDARD  LVCMOS18  [get_ports  si5328_rst_n]
set_property IOSTANDARD  LVCMOS18  [get_ports  iic_mux_rst_n]

# Enables FPGA Fan
set_property PACKAGE_PIN BF21      [get_ports  fan_on]
set_property IOSTANDARD  LVCMOS18  [get_ports  fan_on]

# GPIO LEDs
set_property PACKAGE_PIN AT32      [get_ports  leds[0]]
set_property PACKAGE_PIN AV34      [get_ports  leds[1]]
set_property PACKAGE_PIN AY30      [get_ports  leds[2]]
set_property PACKAGE_PIN BB32      [get_ports  leds[3]]
set_property PACKAGE_PIN BF32      [get_ports  leds[4]]
set_property PACKAGE_PIN AV36      [get_ports  leds[5]]
set_property PACKAGE_PIN AY35      [get_ports  leds[6]]
set_property PACKAGE_PIN BA37      [get_ports  leds[7]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[0]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[1]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[2]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[3]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[4]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[5]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[6]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[7]]

# Reset Pushbutton - North Pushbutton Reset (SW10)
set_property PACKAGE_PIN E34       [get_ports  pb_reset]
set_property IOSTANDARD  LVCMOS12  [get_ports  pb_reset]

# Clock Monitor Outputs on SMAs J34 (clk_si570_mon) and J35 (clk_Si5328_mon)
set_property PACKAGE_PIN AR14      [get_ports  clk_si570_mon]
set_property PACKAGE_PIN AT14      [get_ports  clk_si5328_mon]
set_property IOSTANDARD  LVCMOS18  [get_ports  clk_si570_mon]
set_property IOSTANDARD  LVCMOS18  [get_ports  clk_si5328_mon]

# IIC
set_property PACKAGE_PIN AP21      [get_ports  iic_sda]
set_property PACKAGE_PIN AN21      [get_ports  iic_scl]
set_property IOSTANDARD  LVCMOS18  [get_ports  iic_sda]
set_property IOSTANDARD  LVCMOS18  [get_ports  iic_scl]
