# Title      : Example top level for CPRI design on ZCU102
# Project    : CPRI
#---------------------------------------------------------------------
# File       : cpri_zcu102.xdc
# Author     : Xilinx
#---------------------------------------------------------------------
# Description:
#   This example design for CPRI is designed to be hosted on
#   the ZCU102 Evalutation Board using Chipscope to provide
#   Control and Monitoring of the CPRI core.
#
#---------------------------------------------------------------------
# (c) Copyright 2004 - 2017 Xilinx, Inc. All rights reserved.
#
# This file contains confidential and proprietary information
# of Xilinx, Inc. and is protected under U.S. and
# international copyright and other intellectual property
# laws.
#
# DISCLAIMER
# This disclaimer is not a license and does not grant any
# rights to the materials distributed herewith. Except as
# otherwise provided in a valid license issued to you by
# Xilinx, and to the maximum extent permitted by applicable
# law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
# WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
# AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
# BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
# INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
# (2) Xilinx shall not be liable (whether in contract or tort,
# including negligence, or under any other theory of
# liability) for any loss or damage of any kind or nature
# related to, arising under or in connection with these
# materials, including for any direct, or any indirect,
# special, incidental, or consequential loss or damage
# (including loss of data, profits, goodwill, or any type of
# loss or damage suffered as a result of any action brought
# by a third party) even if such damage or loss was
# reasonably foreseeable or Xilinx had been advised of the
# possibility of the same.
#
# CRITICAL APPLICATIONS
# Xilinx products are not designed or intended to be fail-
# safe, or for use in any application requiring fail-safe
# performance, such as life-support or safety devices or
# systems, Class III medical devices, nuclear facilities,
# applications related to the deployment of airbags, or any
# other applications that could lead to death, personal
# injury, or severe property or environmental damage
# (individually and collectively, "Critical
# Applications"). Customer assumes the sole risk and
# liability of any use of Xilinx products in Critical
# Applications, subject only to applicable laws and
# regulations governing limitations on product liability.
#
# THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
# PART OF THIS FILE AT ALL TIMES.
#-----------------------------------------------------------------------


####### Main Clock constraints #######

# 300MHz System clock constraint
# The auxiliary clock is derived from this and runs at 100MHz
create_clock -name refclk -period 4.069 [get_ports refclk_p]
create_clock -name clk300 -period 3.333 [get_ports clk300_p]

create_generated_clock -name hires_clk [get_pins -filter {REF_PIN_NAME =~ CLKOUT0} -of [get_cells -hier -filter {name =~ mmcm_i}]]
create_generated_clock -name aux_clk   [get_pins -filter {REF_PIN_NAME =~ CLKOUT1} -of [get_cells -hier -filter {name =~ mmcm_i}]]
create_generated_clock -name clk10     [get_pins -filter {REF_PIN_NAME =~ CLKOUT2} -of [get_cells -hier -filter {name =~ mmcm_i}]]
create_generated_clock -name eth_clk   [get_pins -filter {REF_PIN_NAME =~ CLKOUT3} -of [get_cells -hier -filter {name =~ mmcm_i}]]

# Clock crossing constraints for the data generators and monitors in the example design top level
set_false_path -from [get_clocks aux_clk] -to [get_cells {iq_rx_chk_enable_eth_reg[*][0]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {iq_rx_chk_enable_clk_reg[*][0]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {vendor_tx_rx_i/vendor_tx_data_reg[*]}]
set_false_path -from [get_cells {iq_rx_chk_i/error_count_i_reg[*]}]    -to [get_clocks aux_clk]
set_false_path -from [get_cells {iq_rx_chk_i/frame_count_i_reg[*]}]    -to [get_clocks aux_clk]
set_false_path -from [get_cells {vendor_tx_rx_i/error_count_i_reg[*]}] -to [get_clocks aux_clk]
set_false_path -from [get_cells {vendor_tx_rx_i/word_count_i_reg[*]}]  -to [get_clocks aux_clk]
set_false_path -from [get_cells {hdlc_tx_rx_i/error_count_i_reg[*]}]   -to [get_clocks aux_clk]
set_false_path -from [get_cells {hdlc_tx_rx_i/bit_count_i_reg[*]}]     -to [get_clocks aux_clk]
set_false_path -to   [get_cells {gmii_tx_rx_i/tx_eth_half_r_reg*}]

# Constraint to ignore clock crossing between the managment and ethernet clocks
set_false_path -from [get_clocks aux_clk] -to [get_clocks eth_clk]
set_false_path -from [get_clocks eth_clk] -to [get_clocks aux_clk]

# Constraint to ignore clock crossing synchronisers on stat_speed from managment clock to txusrclk & recclk
set_false_path -from [get_clocks aux_clk] -to [get_cells {stat_speed_recclk_reg[0][*]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {stat_speed_clk_reg[0][*]}]
set_false_path -from [get_clocks aux_clk] -to [get_cells {stat_code_clk_reg[0][*]}]

# Signals sampled on the ILA but are sourced in the ethernet clock domain
set_false_path -from [get_clocks eth_clk] -to [get_cells -hier -filter {name =~ *i_ila_tx/U0/ila_core_inst* && IS_SEQUENTIAL}]
set_false_path -from [get_clocks eth_clk] -to [get_cells -hier -filter {name =~ *i_ila_rx/U0/ila_core_inst* && IS_SEQUENTIAL}]

# Signals sampled on the ILA but are sourced in the management clock domain
set_false_path -from [get_clocks aux_clk] -to [get_cells -hier -filter {name =~ *i_ila_tx/U0/ila_core_inst* && IS_SEQUENTIAL}]
set_false_path -from [get_clocks aux_clk] -to [get_cells -hier -filter {name =~ *i_ila_rx/U0/ila_core_inst* && IS_SEQUENTIAL}]
set_false_path -from [get_clocks aux_clk] -to [get_cells -hier -filter {name =~ *i_vio_control/inst* && IS_SEQUENTIAL}]

set_false_path -from [get_cells -hier -filter {name =~ *i_vio_control/inst/PROBE_OUT_ALL_INST/G_PROBE_OUT[*].PROBE_OUT0_INST/Probe_out_reg* && IS_SEQUENTIAL}]
set_false_path -to   [get_cells -hier -filter {name =~ *i_vio_status/inst/PROBE_IN_INST/probe_in_reg_reg* && IS_SEQUENTIAL}]
set_false_path -to   [get_cells -hier -filter {name =~ *i_ila_tx/U0/* && IS_SEQUENTIAL}]
set_false_path -to   [get_cells -hier -filter {name =~ *i_ila_rx/U0/* && IS_SEQUENTIAL}]

####### False and Reset paths #######

# External reset Pushbutton
set_false_path -from [get_ports pb_reset]
set_false_path -from [all_registers -clock clk10]

####### Pinout constraints for ZCU102 #######

####### Placement constraints #######
set_property PACKAGE_PIN E4        [get_ports  txp]
set_property PACKAGE_PIN E3        [get_ports  txn]
set_property PACKAGE_PIN D2        [get_ports  rxp]
set_property PACKAGE_PIN D1        [get_ports  rxn]

# Sys Clk - 300 MHz oscillator
set_property PACKAGE_PIN AL8       [get_ports  clk300_p]
set_property PACKAGE_PIN AL7       [get_ports  clk300_n]
set_property IOSTANDARD  LVDS      [get_ports  clk300_p]
set_property IOSTANDARD  LVDS      [get_ports  clk300_n]

# Output clock to Si5328 Multiplier/Jitter Attenuator
set_property PACKAGE_PIN R10       [get_ports  clk_si5326_p]
set_property PACKAGE_PIN R9        [get_ports  clk_si5326_n]
set_property IOSTANDARD  LVDS      [get_ports  clk_si5326_p]
set_property IOSTANDARD  LVDS      [get_ports  clk_si5326_n]

# GT Reference clock sourced by Si5328 Multiplier/Jitter Attenuator
set_property PACKAGE_PIN B10       [get_ports  refclk_p]
set_property PACKAGE_PIN B9        [get_ports  refclk_n]

# GPIO LEDs
set_property PACKAGE_PIN AG14      [get_ports  leds[0]]
set_property PACKAGE_PIN AF13      [get_ports  leds[1]]
set_property PACKAGE_PIN AE13      [get_ports  leds[2]]
set_property PACKAGE_PIN AJ14      [get_ports  leds[3]]
set_property PACKAGE_PIN AJ15      [get_ports  leds[4]]
set_property PACKAGE_PIN AH13      [get_ports  leds[5]]
set_property PACKAGE_PIN AH14      [get_ports  leds[6]]
set_property PACKAGE_PIN AL12      [get_ports  leds[7]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[0]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[1]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[2]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[3]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[4]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[5]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[6]]
set_property IOSTANDARD  LVCMOS18  [get_ports  leds[7]]

# Reset Pushbutton - North PB (SW18)
set_property PACKAGE_PIN AG15      [get_ports  pb_reset]
set_property IOSTANDARD  LVCMOS18  [get_ports  pb_reset]

# IIC
set_property PACKAGE_PIN L20       [get_ports  iic_sda]
set_property PACKAGE_PIN K20       [get_ports  iic_scl]
set_property IOSTANDARD  LVCMOS18  [get_ports  iic_sda]
set_property IOSTANDARD  LVCMOS18  [get_ports  iic_scl]

# Enable the sfp module can also use jumper on J16
set_property PACKAGE_PIN A12       [get_ports  sfp_enable]
set_property IOSTANDARD  LVCMOS18  [get_ports  sfp_enable]
