%if "%{dist}" == ".el7"
BuildRequires:  binutils, gcc, make, kernel-module-auxiliary-%{disttag}-%{kernel}
%else
BuildRequires:  binutils, gcc, make
%endif
%if %{with kernel_header}
    %define binary_name kernel-module-%{name}-%{disttag}-%{kernel}
%else
    %define binary_name kernel-module-%{name}-%{disttag}-%{kernel}-noheader
%endif

%package -n %{binary_name}
Summary:        %{summary}
Group:          %{group}
Provides:       %{name}-kmod-symvers = %{kernel}

%description -n %{binary_name}
The Linux kernel driver for xilinx X3 Ethernet
controllers.

# Inhibit debuginfo package
%define debug_package %{nil}

# -----------------------------------------------------------------------------

%prep
%setup -q

# -----------------------------------------------------------------------------

%build

[ -d "%{kpath}" ] || {
  set +x
  echo >&2 "ERROR: Kernel headers not found.  They should be at:"
  echo >&2 "ERROR:   %{kpath}"
  echo >&2 "Hint: Install the $(echo '%{kernel}' | sed -r 's/(.*)(smp|hugemem|largesmp|PAE|xen)$/kernel-\2-devel-\1/; t; s/^/kernel-devel-/') package"
  exit 1
}

cd %{_builddir}/%{name}-%{version}

# do the build
export MAKEFLAGS="-j4 $MAKEFLAGS"
%{__make} -C linux_net KVER=%{kernel} KPATH="%{kpath}" modules

# -----------------------------------------------------------------------------

%install

cd "%{_builddir}/%{name}-%{version}"

# do the install
%{__make} -C linux_net INSTALL_MOD_PATH="%{buildroot}" INSTALL_MOD_DIR="updates" \
  KVER=%{kernel} KPATH="%{kpath}" modules_install
%if %{with kernel_header}
    mkdir -p %{buildroot}/lib/modules/%{kernel}/build/include/linux/net/xilinx
    %{__install} -m 0644 linux_net/include/linux/net/xilinx/xlnx_efct.h \
      %{buildroot}/lib/modules/%{kernel}/build/include/linux/net/xilinx/xlnx_efct.h
%endif
# rpm will complain about these files generated by depmod
rm -f %{buildroot}/lib/modules/%{kernel}/modules.*

# -----------------------------------------------------------------------------

%clean
%{__rm} -rf %{buildroot}

# -----------------------------------------------------------------------------

%post -n %{binary_name}
/sbin/depmod -a %{kernel}
if [ "$(uname -r)" = "%{kernel}" ]; then
    if [ -x /etc/hotplug/pci.rc ]; then
        /etc/hotplug/pci.rc start >/dev/null
    fi
    modprobe xilinx_efct
fi
udevadm control --reload
true

%postun -n %{binary_name}
/sbin/rmmod xilinx_efct >/dev/null 2>&1
/sbin/depmod -a %{kernel}
true

# -----------------------------------------------------------------------------

%files -n %{binary_name}
%defattr(-,root,root,-)

%if %{with kernel_header}
    /lib/modules/%{kernel}/build/include/linux/net/xilinx/
%endif
/lib/modules/%{kernel}/updates/xilinx_efct.ko

