%{expand: %%(echo "%defattr (-,root,root)" > %{_builddir}/file.list; echo "/lib/modules/%2-%1/updates" >> %{_builddir}/file.list;)}

%if %{with kernel_header}
	%{expand: %%(echo "/lib/modules/%2-%1/source/include/linux/net/" >> %{_builddir}/file.list )}
	%kernel_module_package -x debug -x trace -x rt_debug -f %{_builddir}/file.list
%else
	%kernel_module_package -x debug -x trace -x rt_debug -n %name-noheader
%endif
BuildRequires: %kernel_module_package_buildreqs
Group: System/Kernel

# -----------------------------------------------------------------------------

%prep
%setup -q
set -- *
mkdir source
mv "$@" source/
echo "xilinx_efct.ko external" > source/linux_net/drivers/net/ethernet/xilinx/Module.supported
mkdir obj

# -----------------------------------------------------------------------------

%build
[ -d "%{kpath}" ] || {
	set +x
	echo >&2 "ERROR: Kernel headers not found."
	echo >&2 "Hint: Install kernel-devel"
	exit 1
}

export EXTRA_CFLAGS='-DVERSION="%version"'
for flavor in %flavors_to_build; do
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    %{__make} -C $PWD/obj/$flavor/linux_net/drivers/net/ethernet/xilinx KVER=%{kernel} KPATH="%{kernel_source $flavor}" modules
done

# -----------------------------------------------------------------------------

%install
export INSTALL_MOD_PATH=%{buildroot}
export INSTALL_MOD_DIR=updates

for flavor in %flavors_to_build; do
    make -C %{kernel_source $flavor} modules_install CONFIG_XILINX_EFCT=m M=$PWD/obj/$flavor/linux_net/drivers/net/ethernet/xilinx
    %if %{with kernel_header}
        krel=$(make -si -C /usr/src/linux-obj/%_target_cpu/$flavor/ %linux_make_arch kernelrelease 2>/dev/null)
	install -d -m 755 %{buildroot}/lib/modules/${krel}/source/include/linux/net/xilinx
        %{__install} -m 0644 obj/$flavor/linux_net/include/linux/net/xilinx/xlnx_efct.h \
          %{buildroot}/lib/modules/${krel}/source/include/linux/net/xilinx/xlnx_efct.h
    %endif
done

