/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */
#ifdef CONFIG_XILINX_DEBUGFS

#ifndef EFCT_DEBUGFS_H
#define EFCT_DEBUGFS_H

void efct_init_debugfs(const char *module);
void efct_init_debugfs_nic(struct efct_nic *efct);
void efct_init_debugfs_func(struct efct_device *efct_dev);
void efct_fini_debugfs_func(struct efct_device *efct_dev);
void efct_fini_debugfs_nic(struct efct_nic *efct);
void efct_fini_debugfs_rx_queue(struct efct_rx_queue *rx_queue);
void efct_init_debugfs_rx_queue(struct efct_rx_queue *rx_queue);
void efct_fini_debugfs_tx_queue(struct efct_tx_queue *tx_queue);
void efct_init_debugfs_tx_queue(struct efct_tx_queue *tx_queue);
void efct_fini_debugfs_ev_queue(struct efct_ev_queue *ev_queue);
void efct_init_debugfs_ev_queue(struct efct_ev_queue *ev_queue);
#ifdef CONFIG_XILINX_AUX_EFCT
void efct_init_debugfs_aux_dev_client(struct xlnx_efct_client *client);
void efct_init_debugfs_aux_dev(struct efct_nic *efct);
void efct_fini_debugfs_aux_dev_client(struct xlnx_efct_client *client);
void efct_fini_debugfs_aux_dev(struct efct_nic *efct);
#endif
void efct_fini_debugfs(void);

#endif /* EFCT_DEBUGFS_H */
#endif /* CONFIG_XILINX_DEBUGFS */
