/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */
#ifndef _EFCT_DEVLINK_H
#define _EFCT_DEVLINK_H

#include "efct_driver.h"
#ifndef EFCT_USE_KCOMPAT
#include <net/devlink.h>
#endif

int efct_probe_devlink(struct efct_device *efct_dev);
int efct_devlink_port_register(struct efct_nic *efct);
void efct_fini_devlink(struct efct_device *efct_dev);
int efct_devlink_register(struct efct_device *efct_dev);
void efct_devlink_unregister(struct efct_device *efct_dev);

#if !defined(EFCT_USE_KCOMPAT) || defined(EFCT_USE_DEVLINK)
struct devlink_port *efct_get_devlink_port(struct net_device *dev);
#endif

#endif	/* _EFCT_DEVLINK_H */
