/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#ifndef EFCT_NIC_H
#define EFCT_NIC_H

#include "efct_driver.h"

/* NIC-generic software stats */
enum {
	GENERIC_STAT_rx_drops,
	GENERIC_STAT_tx_drops,
	GENERIC_STAT_COUNT
};

#define EFCT_GENERIC_SW_STAT(ext_name)                          \
	[GENERIC_STAT_ ## ext_name] = { #ext_name, 0, 0 }

enum {
	EFCT_STAT_port_tx_bytes = GENERIC_STAT_COUNT,
	EFCT_STAT_port_tx_packets,
	EFCT_STAT_port_tx_pause,
	EFCT_STAT_port_tx_unicast,
	EFCT_STAT_port_tx_multicast,
	EFCT_STAT_port_tx_broadcast,
	EFCT_STAT_port_tx_lt64,
	EFCT_STAT_port_tx_64,
	EFCT_STAT_port_tx_65_to_127,
	EFCT_STAT_port_tx_128_to_255,
	EFCT_STAT_port_tx_256_to_511,
	EFCT_STAT_port_tx_512_to_1023,
	EFCT_STAT_port_tx_1024_to_15xx,
	EFCT_STAT_port_tx_15xx_to_jumbo,
	EFCT_STAT_port_rx_bytes,
	EFCT_STAT_port_rx_packets,
	EFCT_STAT_port_rx_good,
	EFCT_STAT_port_rx_bad,
	EFCT_STAT_port_rx_bad_bytes,
	EFCT_STAT_port_rx_pause,
	EFCT_STAT_port_rx_unicast,
	EFCT_STAT_port_rx_multicast,
	EFCT_STAT_port_rx_broadcast,
	EFCT_STAT_port_rx_lt64,
	EFCT_STAT_port_rx_64,
	EFCT_STAT_port_rx_65_to_127,
	EFCT_STAT_port_rx_128_to_255,
	EFCT_STAT_port_rx_256_to_511,
	EFCT_STAT_port_rx_512_to_1023,
	EFCT_STAT_port_rx_1024_to_15xx,
	EFCT_STAT_port_rx_15xx_to_jumbo,
	EFCT_STAT_port_rx_gtjumbo,
	EFCT_STAT_port_rx_bad_gtjumbo,
	EFCT_STAT_port_rx_align_error,
	EFCT_STAT_port_rx_length_error,
	EFCT_STAT_port_rx_overflow,
	EFCT_STAT_port_rx_nodesc_drops,
	EFCT_STAT_port_pm_discard_vfifo_full,
	EFCT_STAT_port_rxdp_q_disabled_pkts,
	EFCT_STAT_port_rxdp_di_dropped_pkts,
	EFCT_STAT_port_ctpio_underflow_fail,
	EFCT_STAT_port_ctpio_success,
	EFCT_STAT_COUNT
};

struct efct_nic_data {
	struct efct_nic *efct;
	u64 stats[EFCT_STAT_COUNT];
};

struct efct_self_tests {
	/* online tests */
	int phy_alive;
	int interrupt;
	int *eventq_dma;
	int *eventq_int;
};

#define EFCT_TEST  1

#define EFCT_DRVGEN_CODE(_magic)	((_magic) & 0xff)

extern const struct efct_nic_type efct_nic_type;
int efct_init_datapath_caps(struct efct_nic *efct);
int efct_start_evqs(struct efct_nic *efct);
void efct_stop_evqs(struct efct_nic *efct);
size_t efct_update_stats_common(struct efct_nic *efct, u64 *full_stats,
				struct rtnl_link_stats64 *core_stats);
int efct_nic_describe_stats(const struct efct_hw_stat_desc *desc, size_t count,
			    const unsigned long *mask, u8 *names);
void efct_nic_update_stats(const struct efct_hw_stat_desc *desc, size_t count,
			   const unsigned long *mask, u64 *stats,
			   const __le64 *mc_initial_stats, const __le64 *mc_stats);
#ifdef CONFIG_XILINX_MCDI_LOGGING
void efct_init_mcdi_logging(struct efct_device *efct_dev);
void efct_fini_mcdi_logging(struct efct_device *efct_dev);
#else
static inline void efct_init_mcdi_logging(struct efct_device *efct_dev) {}
static inline void efct_fini_mcdi_logging(struct efct_device *efct_dev) {}
#endif
#endif
