/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#ifndef	EFCT_REG_H
#define	EFCT_REG_H

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_HW_REV_ID(32bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_HW_REV_ID 0x00000000
#define	ER_HZ_REG_HOST_HW_REV_ID_RESET 0x0

#define	ERF_HZ_MAJOR_LBN 24
#define	ERF_HZ_MAJOR_WIDTH 8
#define	ERF_HZ_MINOR_LBN 12
#define	ERF_HZ_MINOR_WIDTH 12
#define	ERF_HZ_PATCH_LBN 0
#define	ERF_HZ_PATCH_WIDTH 12

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_NIC_REV_ID(32bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_NIC_REV_ID 0x00000004
#define	ER_HZ_REG_HOST_NIC_REV_ID_RESET 0x0

/* defined as ERF_HZ_MAJOR_LBN 24; access=RO reset=0 */
/* defined as ERF_HZ_MAJOR_WIDTH 8 */
/* defined as ERF_HZ_MINOR_LBN 12; access=RO reset=0 */
/* defined as ERF_HZ_MINOR_WIDTH 12 */
/* defined as ERF_HZ_PATCH_LBN 0; access=RO reset=0 */
/* defined as ERF_HZ_PATCH_WIDTH 12 */

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_NIC_MAGIC(32bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_NIC_MAGIC 0x00000008
#define	ER_HZ_REG_HOST_NIC_MAGIC_RESET 0x0

#define	ERF_HZ_NIC_MAGIC_LBN 0
#define	ERF_HZ_NIC_MAGIC_WIDTH 32

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_NUM_PORTS(32bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_NUM_PORTS 0x0000000c
#define	ER_HZ_REG_HOST_NUM_PORTS_RESET 0x0

#define	ERF_HZ_NUM_PORTS_LBN 0
#define	ERF_HZ_NUM_PORTS_WIDTH 32

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_MC_SFT_STATUS(32bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_MC_SFT_STATUS 0x00000010
#define	ER_HZ_FUN_WIN_REG_HOST_MC_SFT_STATUS_STEP 4
#define	ER_HZ_FUN_WIN_REG_HOST_MC_SFT_STATUS_ROWS 2
#define	ER_HZ_REG_HOST_MC_SFT_STATUS_RESET 0x0

#define	ERF_HZ_MC_SFT_STATUS_LBN 0
#define	ERF_HZ_MC_SFT_STATUS_WIDTH 32

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_PARAMS_TLV_LEN(32bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_PARAMS_TLV_LEN 0x00000020
#define	ER_HZ_REG_HOST_PARAMS_TLV_LEN_RESET 0x0

#define	ERF_HZ_PARAMS_TLV_LEN_LBN 0
#define	ERF_HZ_PARAMS_TLV_LEN_WIDTH 32

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_PARAMS_TLV(32bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_PARAMS_TLV 0x00000024
#define	ER_HZ_FUN_WIN_REG_HOST_PARAMS_TLV_STEP 4
#define	ER_HZ_FUN_WIN_REG_HOST_PARAMS_TLV_ROWS 247
#define	ER_HZ_REG_HOST_PARAMS_TLV_RESET 0x0

#define	ERF_HZ_PARAMS_TLV_LBN 0
#define	ERF_HZ_PARAMS_TLV_WIDTH 32

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_VSEC_HDR(64bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_VSEC_HDR 0x00000400
#define	ER_HZ_REG_HOST_VSEC_HDR_RESET 0x1810000001

#define	ERF_HZ_LENGTH_LBN 32
#define	ERF_HZ_LENGTH_WIDTH 32
#define	ERF_HZ_LAST_CAPABILITY_LBN 28
#define	ERF_HZ_LAST_CAPABILITY_WIDTH 1
#define	ERF_HZ_FORMAT_REV_CODE_LBN 20
#define	ERF_HZ_FORMAT_REV_CODE_WIDTH 8
#define	ERF_HZ_FORMAT_ID_LBN 0
#define	ERF_HZ_FORMAT_ID_WIDTH 20

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_VSEC_TBL_FRMT(64bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_VSEC_TBL_FRMT 0x00000408
#define	ER_HZ_REG_HOST_VSEC_TBL_FRMT_RESET 0x8

#define	ERF_HZ_ENTRY_SIZE_LBN 0
#define	ERF_HZ_ENTRY_SIZE_WIDTH 8

/*------------------------------------------------------------*/
/* ER_HZ_FUN_WIN_REG_HOST_VSEC_TBL_ENTRY(64bit):
 *
 */
#define	ER_HZ_FUN_WIN_REG_HOST_VSEC_TBL_ENTRY 0x00000410
#define	ER_HZ_REG_HOST_VSEC_TBL_ENTRY_RESET 0x58330020

#define	ERF_HZ_FUNC_CTL_WIN_OFF_16B_LBN 35
#define	ERF_HZ_FUNC_CTL_WIN_OFF_16B_WIDTH 29
#define	ERF_HZ_FUNC_CTL_WIN_BAR_LBN 32
#define	ERF_HZ_FUNC_CTL_WIN_BAR_WIDTH 3
#define	ERF_HZ_PROJECT_ID_LBN 16
#define	ERF_HZ_PROJECT_ID_WIDTH 16
#define	ERF_HZ_TYPE_REVISION_LBN 8
#define	ERF_HZ_TYPE_REVISION_WIDTH 5
#define	ERF_HZ_TABLE_TYPE_LBN 0
#define	ERF_HZ_TABLE_TYPE_WIDTH 8

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_MC_DOORBELL(64bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_MC_DOORBELL 0x00000800
/* ER_HZ_PORT1_REG_HOST_MC_DOORBELL(64bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_MC_DOORBELL 0x00080800
#define	ER_HZ_REG_HOST_MC_DOORBELL_RESET 0x0

#define	ERF_HZ_MC_DOORBELL_LBN 0
#define	ERF_HZ_MC_DOORBELL_WIDTH 64

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_EVQ_INT_PRIME(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_EVQ_INT_PRIME 0x00000808
/* ER_HZ_PORT1_REG_HOST_EVQ_INT_PRIME(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_EVQ_INT_PRIME 0x00080808
#define	ER_HZ_REG_HOST_EVQ_INT_PRIME_RESET 0x0

#define	ERF_HZ_READ_IDX_LBN 16
#define	ERF_HZ_READ_IDX_WIDTH 16
#define	ERF_HZ_EVQ_ID_LBN 0
#define	ERF_HZ_EVQ_ID_WIDTH 16

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_MC_DB_OWNER(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_MC_DB_OWNER 0x0000080c
/* ER_HZ_PORT1_REG_HOST_MC_DB_OWNER(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_MC_DB_OWNER 0x0008080c
#define	ER_HZ_REG_HOST_MC_DB_OWNER_RESET 0x0

#define	ERF_HZ_OWNERSHIP_LBN 0
#define	ERF_HZ_OWNERSHIP_WIDTH 1

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_MC_PIO(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_MC_PIO 0x00001000
#define	ER_HZ_PORT0_REG_HOST_MC_PIO_STEP 4
#define	ER_HZ_PORT0_REG_HOST_MC_PIO_ROWS 272
/* ER_HZ_PORT1_REG_HOST_MC_PIO(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_MC_PIO 0x00081000
#define	ER_HZ_PORT1_REG_HOST_MC_PIO_STEP 4
#define	ER_HZ_PORT1_REG_HOST_MC_PIO_ROWS 272
#define	ER_HZ_REG_HOST_MC_PIO_RESET 0x0

#define	ERF_HZ_MC_PIO_LBN 0
#define	ERF_HZ_MC_PIO_WIDTH 32

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_RX_BUFFER_POST(64bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_RX_BUFFER_POST 0x00002000
#define	ER_HZ_PORT0_REG_HOST_RX_BUFFER_POST_STEP 4096
#define	ER_HZ_PORT0_REG_HOST_RX_BUFFER_POST_ROWS 16
/* ER_HZ_PORT1_REG_HOST_RX_BUFFER_POST(64bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_RX_BUFFER_POST 0x00082000
#define	ER_HZ_PORT1_REG_HOST_RX_BUFFER_POST_STEP 4096
#define	ER_HZ_PORT1_REG_HOST_RX_BUFFER_POST_ROWS 16
#define	ER_HZ_REG_HOST_RX_BUFFER_POST_RESET 0x0

#define	ERF_HZ_ROLLOVER_LBN 53
#define	ERF_HZ_ROLLOVER_WIDTH 1
#define	ERF_HZ_SENTINEL_VALUE_LBN 52
#define	ERF_HZ_SENTINEL_VALUE_WIDTH 1
#define	ERF_HZ_PAGE_ADDRESS_LBN 0
#define	ERF_HZ_PAGE_ADDRESS_WIDTH 52

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_THE_TIME(64bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_THE_TIME 0x00002008
#define	ER_HZ_PORT0_REG_HOST_THE_TIME_STEP 4096
#define	ER_HZ_PORT0_REG_HOST_THE_TIME_ROWS 16
/* ER_HZ_PORT1_REG_HOST_THE_TIME(64bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_THE_TIME 0x00082008
#define	ER_HZ_PORT1_REG_HOST_THE_TIME_STEP 4096
#define	ER_HZ_PORT1_REG_HOST_THE_TIME_ROWS 16
#define	ER_HZ_REG_HOST_THE_TIME_RESET 0x0

#define	ERF_HZ_THE_TIME_LBN 0
#define	ERF_HZ_THE_TIME_WIDTH 64

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_EVQ_UNSOL_CREDIT_GRANT(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_EVQ_UNSOL_CREDIT_GRANT 0x00012000
#define	ER_HZ_PORT0_REG_HOST_EVQ_UNSOL_CREDIT_GRANT_STEP 4096
#define	ER_HZ_PORT0_REG_HOST_EVQ_UNSOL_CREDIT_GRANT_ROWS 32
/* ER_HZ_PORT1_REG_HOST_EVQ_UNSOL_CREDIT_GRANT(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_EVQ_UNSOL_CREDIT_GRANT 0x00092000
#define	ER_HZ_PORT1_REG_HOST_EVQ_UNSOL_CREDIT_GRANT_STEP 4096
#define	ER_HZ_PORT1_REG_HOST_EVQ_UNSOL_CREDIT_GRANT_ROWS 32
#define	ER_HZ_REG_HOST_EVQ_UNSOL_CREDIT_GRANT_RESET 0x0

#define	ERF_HZ_CLEAR_OVERFLOW_LBN 16
#define	ERF_HZ_CLEAR_OVERFLOW_WIDTH 1
#define	ERF_HZ_GRANT_SEQ_LBN 0
#define	ERF_HZ_GRANT_SEQ_WIDTH 16

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION0(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION0 0x00042000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION0_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION0_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION0(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION0 0x000c2000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION0_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION0_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION0_RESET 0x0

#define	ERF_HZ_CTPIO_LBN 0
#define	ERF_HZ_CTPIO_WIDTH 32

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION1(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION1 0x00043000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION1_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION1_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION1(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION1 0x000c3000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION1_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION1_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION1_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION2(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION2 0x00044000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION2_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION2_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION2(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION2 0x000c4000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION2_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION2_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION2_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION3(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION3 0x00045000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION3_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION3_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION3(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION3 0x000c5000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION3_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION3_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION3_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION4(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION4 0x00046000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION4_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION4_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION4(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION4 0x000c6000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION4_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION4_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION4_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION5(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION5 0x00047000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION5_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION5_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION5(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION5 0x000c7000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION5_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION5_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION5_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION6(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION6 0x00048000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION6_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION6_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION6(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION6 0x000c8000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION6_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION6_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION6_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION7(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION7 0x00049000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION7_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION7_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION7(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION7 0x000c9000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION7_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION7_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION7_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION8(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION8 0x0004a000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION8_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION8_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION8(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION8 0x000ca000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION8_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION8_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION8_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION9(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION9 0x0004b000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION9_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION9_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION9(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION9 0x000cb000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION9_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION9_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION9_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION10(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION10 0x0004c000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION10_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION10_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION10(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION10 0x000cc000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION10_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION10_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION10_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION11(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION11 0x0004d000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION11_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION11_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION11(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION11 0x000cd000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION11_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION11_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION11_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION12(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION12 0x0004e000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION12_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION12_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION12(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION12 0x000ce000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION12_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION12_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION12_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION13(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION13 0x0004f000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION13_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION13_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION13(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION13 0x000cf000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION13_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION13_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION13_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION14(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION14 0x00050000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION14_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION14_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION14(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION14 0x000d0000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION14_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION14_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION14_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ER_HZ_PORT0_REG_HOST_CTPIO_REGION15(32bit):
 *
 */
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION15 0x00051000
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION15_STEP 4
#define	ER_HZ_PORT0_REG_HOST_CTPIO_REGION15_ROWS 1024
/* ER_HZ_PORT1_REG_HOST_CTPIO_REGION15(32bit):
 *
 */
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION15 0x000d1000
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION15_STEP 4
#define	ER_HZ_PORT1_REG_HOST_CTPIO_REGION15_ROWS 1024
#define	ER_HZ_REG_HOST_CTPIO_REGION15_RESET 0x0

/* defined as ERF_HZ_CTPIO_LBN 0; access=WO reset=0 */
/* defined as ERF_HZ_CTPIO_WIDTH 32 */

/*------------------------------------------------------------*/
/* ES_PCI_EXPRESS_XCAP_HDR */
#define	ESF_HZ_PCI_EXPRESS_XCAP_NEXT_LBN 20
#define	ESF_HZ_PCI_EXPRESS_XCAP_NEXT_WIDTH 12
#define	ESF_HZ_PCI_EXPRESS_XCAP_VER_LBN 16
#define	ESF_HZ_PCI_EXPRESS_XCAP_VER_WIDTH 4
#define	ESE_HZ_PCI_EXPRESS_XCAP_VER_PCI_EXPRESS_XCAP_VER_VSEC 1
#define	ESF_HZ_PCI_EXPRESS_XCAP_ID_LBN 0
#define	ESF_HZ_PCI_EXPRESS_XCAP_ID_WIDTH 16
#define	ESE_HZ_PCI_EXPRESS_XCAP_ID_PCI_EXPRESS_XCAP_ID_VNDR 0xb
#define	ESE_HZ_PCI_EXPRESS_XCAP_HDR_STRUCT_SIZE 32

/*------------------------------------------------------------*/
/* ES_VIRTIO_DESC */
#define	ESF_HZ_NEXT_LBN 112
#define	ESF_HZ_NEXT_WIDTH 16
#define	ESF_HZ_FLAGS_LBN 96
#define	ESF_HZ_FLAGS_WIDTH 16
#define	ESF_HZ_FLAG_IND_LBN 98
#define	ESF_HZ_FLAG_IND_WIDTH 1
#define	ESF_HZ_FLAG_WRITE_LBN 97
#define	ESF_HZ_FLAG_WRITE_WIDTH 1
#define	ESF_HZ_FLAG_NEXT_LBN 96
#define	ESF_HZ_FLAG_NEXT_WIDTH 1
#define	ESF_HZ_LEN_LBN 64
#define	ESF_HZ_LEN_WIDTH 32
#define	ESF_HZ_ADDR_LBN 0
#define	ESF_HZ_ADDR_WIDTH 64
#define	ESE_HZ_VIRTIO_DESC_STRUCT_SIZE 128

/*------------------------------------------------------------*/
/* ES_VIRTIO_NET_HDR */
#define	ESF_HZ_NUM_BUFS_LBN 80
#define	ESF_HZ_NUM_BUFS_WIDTH 16
#define	ESF_HZ_CSUM_OFFST_LBN 64
#define	ESF_HZ_CSUM_OFFST_WIDTH 16
#define	ESF_HZ_CSUM_START_LBN 48
#define	ESF_HZ_CSUM_START_WIDTH 16
#define	ESF_HZ_GSO_SZ_LBN 32
#define	ESF_HZ_GSO_SZ_WIDTH 16
#define	ESF_HZ_HDR_LEN_LBN 16
#define	ESF_HZ_HDR_LEN_WIDTH 16
#define	ESF_HZ_GSO_TYPE_LBN 8
#define	ESF_HZ_GSO_TYPE_WIDTH 8
#define	ESE_HZ_GSO_TYPE_GSO_ECN 128
#define	ESE_HZ_GSO_TYPE_GSO_TCPV6 4
#define	ESE_HZ_GSO_TYPE_GSO_UDP 3
#define	ESE_HZ_GSO_TYPE_GSO_TCPV4 1
#define	ESE_HZ_GSO_TYPE_GSO_NONE 0
#define	ESF_HZ_FLAGS_2_LBN 0
#define	ESF_HZ_FLAGS_2_WIDTH 8
#define	ESF_HZ_RSC_INFO_LBN 2
#define	ESF_HZ_RSC_INFO_WIDTH 1
#define	ESF_HZ_DATA_VALID_LBN 1
#define	ESF_HZ_DATA_VALID_WIDTH 1
#define	ESF_HZ_NEEDS_CSUM_LBN 0
#define	ESF_HZ_NEEDS_CSUM_WIDTH 1
#define	ESE_HZ_VIRTIO_NET_HDR_STRUCT_SIZE 96

/*------------------------------------------------------------*/
/* ES_VIRTIO_PCI_COMMON_CFG */
#define	ESF_HZ_QUEUE_DEVICE_LBN 384
#define	ESF_HZ_QUEUE_DEVICE_WIDTH 64
#define	ESF_HZ_QUEUE_DRIVER_LBN 320
#define	ESF_HZ_QUEUE_DRIVER_WIDTH 64
#define	ESF_HZ_QUEUE_DESC_LBN 256
#define	ESF_HZ_QUEUE_DESC_WIDTH 64
#define	ESF_HZ_QUEUE_NOTIFY_OFF_LBN 240
#define	ESF_HZ_QUEUE_NOTIFY_OFF_WIDTH 16
#define	ESF_HZ_QUEUE_ENABLE_LBN 224
#define	ESF_HZ_QUEUE_ENABLE_WIDTH 16
#define	ESF_HZ_QUEUE_MSIX_VECTOR_LBN 208
#define	ESF_HZ_QUEUE_MSIX_VECTOR_WIDTH 16
#define	ESF_HZ_QUEUE_SIZE_LBN 192
#define	ESF_HZ_QUEUE_SIZE_WIDTH 16
#define	ESF_HZ_QUEUE_SELECT_LBN 176
#define	ESF_HZ_QUEUE_SELECT_WIDTH 16
#define	ESF_HZ_CONFIG_GENERATION_LBN 168
#define	ESF_HZ_CONFIG_GENERATION_WIDTH 8
#define	ESF_HZ_DEVICE_STATUS_LBN 160
#define	ESF_HZ_DEVICE_STATUS_WIDTH 8
#define	ESF_HZ_NUM_QUEUES_LBN 144
#define	ESF_HZ_NUM_QUEUES_WIDTH 16
#define	ESF_HZ_MSIX_CONFIG_LBN 128
#define	ESF_HZ_MSIX_CONFIG_WIDTH 16
#define	ESF_HZ_DRIVER_FEATURE_LBN 96
#define	ESF_HZ_DRIVER_FEATURE_WIDTH 32
#define	ESF_HZ_DRIVER_FEATURE_SELECT_LBN 64
#define	ESF_HZ_DRIVER_FEATURE_SELECT_WIDTH 32
#define	ESF_HZ_DEVICE_FEATURE_LBN 32
#define	ESF_HZ_DEVICE_FEATURE_WIDTH 32
#define	ESF_HZ_DEVICE_FEATURE_SELECT_LBN 0
#define	ESF_HZ_DEVICE_FEATURE_SELECT_WIDTH 32
#define	ESE_HZ_VIRTIO_PCI_COMMON_CFG_STRUCT_SIZE 448

/*------------------------------------------------------------*/
/* ES_VIRTIO_PCI_VCAP */
#define	ESF_HZ_LENGTH_2_LBN 96
#define	ESF_HZ_LENGTH_2_WIDTH 32
#define	ESF_HZ_OFFSET_LBN 64
#define	ESF_HZ_OFFSET_WIDTH 32
#define	ESF_HZ_PADDING_LBN 40
#define	ESF_HZ_PADDING_WIDTH 24
#define	ESF_HZ_BAR_LBN 32
#define	ESF_HZ_BAR_WIDTH 8
#define	ESF_HZ_CFG_TYPE_LBN 24
#define	ESF_HZ_CFG_TYPE_WIDTH 8
#define	ESE_HZ_CFG_TYPE_VIRTIO_PCI_CFG 5
#define	ESE_HZ_CFG_TYPE_VIRTIO_DEVICE_CFG 4
#define	ESE_HZ_CFG_TYPE_VIRTIO_ISR_CFG 3
#define	ESE_HZ_CFG_TYPE_VIRTIO_NOTIFY_CFG 2
#define	ESE_HZ_CFG_TYPE_VIRTIO_COMMON_CFG 1
#define	ESF_HZ_CAP_LEN_LBN 16
#define	ESF_HZ_CAP_LEN_WIDTH 8
#define	ESF_HZ_CAP_NEXT_LBN 8
#define	ESF_HZ_CAP_NEXT_WIDTH 8
#define	ESF_HZ_CAP_ID_LBN 0
#define	ESF_HZ_CAP_ID_WIDTH 8
#define	ESE_HZ_VIRTIO_PCI_VCAP_STRUCT_SIZE 128

/*------------------------------------------------------------*/
/* ES_VIRTQ_AVAIL_RING */
#define	ESF_HZ_USED_EVENT_LBN 48
#define	ESF_HZ_USED_EVENT_WIDTH 16
#define	ESF_HZ_AVAIL_RING_LBN 32
#define	ESF_HZ_AVAIL_RING_WIDTH 16
#define	ESE_HZ_AVAIL_RING_LENMIN 16
#define	ESE_HZ_AVAIL_RING_LENMAX 524288
#define	ESF_HZ_IDX_LBN 16
#define	ESF_HZ_IDX_WIDTH 16
#define	ESF_HZ_FLAGS_3_LBN 0
#define	ESF_HZ_FLAGS_3_WIDTH 16
#define	ESF_HZ_FLAG_NO_INT_LBN 0
#define	ESF_HZ_FLAG_NO_INT_WIDTH 1
#define	ESE_HZ_VIRTQ_AVAIL_RING_STRUCT_SIZE 64

/*------------------------------------------------------------*/
/* ES_VIRTQ_USED_ELEM */
#define	ESF_HZ_LEN_2_LBN 32
#define	ESF_HZ_LEN_2_WIDTH 32
#define	ESF_HZ_ID_LBN 0
#define	ESF_HZ_ID_WIDTH 32
#define	ESE_HZ_VIRTQ_USED_ELEM_STRUCT_SIZE 64

/*------------------------------------------------------------*/
/* ES_VIRTQ_USED_RING */
#define	ESF_HZ_AVAIL_EVENT_LBN 96
#define	ESF_HZ_AVAIL_EVENT_WIDTH 16
#define	ESF_HZ_USED_RING_LBN 32
#define	ESF_HZ_USED_RING_WIDTH 64
#define	ESE_HZ_USED_RING_LENMIN 64
#define	ESE_HZ_USED_RING_LENMAX 2097152
#define	ESF_HZ_IDX_LBN 16
#define	ESF_HZ_IDX_WIDTH 16
#define	ESF_HZ_FLAGS_4_LBN 0
#define	ESF_HZ_FLAGS_4_WIDTH 16
#define	ESE_HZ_VIRTQ_USED_RING_STRUCT_SIZE 112

/*------------------------------------------------------------*/
/* ES_xn_base_event */
#define	ESF_HZ_EV_TYPE_LBN 60
#define	ESF_HZ_EV_TYPE_WIDTH 4
#define	ESF_HZ_EV_PHASE_LBN 59
#define	ESF_HZ_EV_PHASE_WIDTH 1
#define	ESE_HZ_XN_BASE_EVENT_STRUCT_SIZE 64

/*------------------------------------------------------------*/
/* ES_xn_ctl_event */
#define	ESF_HZ_EV_CTL_TYPE_LBN 60
#define	ESF_HZ_EV_CTL_TYPE_WIDTH 4
#define	ESF_HZ_EV_CTL_PHASE_LBN 59
#define	ESF_HZ_EV_CTL_PHASE_WIDTH 1
#define	ESF_HZ_EV_CTL_SUBTYPE_LBN 53
#define	ESF_HZ_EV_CTL_SUBTYPE_WIDTH 6
#define	ESE_HZ_XN_CTL_EVENT_STRUCT_SIZE 64

/*------------------------------------------------------------*/
/* ES_xn_ctpio_hdr */
#define	ESF_HZ_CTPIO_HDR_RSVD_LBN 27
#define	ESF_HZ_CTPIO_HDR_RSVD_WIDTH 37
#define	ESF_HZ_CTPIO_HDR_ACTION_LBN 24
#define	ESF_HZ_CTPIO_HDR_ACTION_WIDTH 3
#define	ESF_HZ_CTPIO_HDR_WARM_FLAG_LBN 23
#define	ESF_HZ_CTPIO_HDR_WARM_FLAG_WIDTH 1
#define	ESF_HZ_CTPIO_HDR_TIMESTAMP_FLAG_LBN 22
#define	ESF_HZ_CTPIO_HDR_TIMESTAMP_FLAG_WIDTH 1
#define	ESF_HZ_CTPIO_HDR_CT_THRESH_LBN 14
#define	ESF_HZ_CTPIO_HDR_CT_THRESH_WIDTH 8
#define	ESF_HZ_CTPIO_HDR_PACKET_LENGTH_LBN 0
#define	ESF_HZ_CTPIO_HDR_PACKET_LENGTH_WIDTH 14
#define	ESE_HZ_XN_CTPIO_HDR_STRUCT_SIZE 64

/*------------------------------------------------------------*/
/* ES_xn_flush_evnt */
#define	ESF_HZ_EV_FLSH_TYPE_LBN 60
#define	ESF_HZ_EV_FLSH_TYPE_WIDTH 4
#define	ESF_HZ_EV_FLSH_PHASE_LBN 59
#define	ESF_HZ_EV_FLSH_PHASE_WIDTH 1
#define	ESF_HZ_EV_FLSH_SUBTYPE_LBN 53
#define	ESF_HZ_EV_FLSH_SUBTYPE_WIDTH 6
#define	ESF_HZ_EV_FLSH_RSVD_LBN 24
#define	ESF_HZ_EV_FLSH_RSVD_WIDTH 29
#define	ESF_HZ_EV_FLSH_QUEUE_ID_LBN 16
#define	ESF_HZ_EV_FLSH_QUEUE_ID_WIDTH 8
#define	ESF_HZ_EV_FLSH_REASON_LBN 10
#define	ESF_HZ_EV_FLSH_REASON_WIDTH 6
#define	ESF_HZ_EV_FLSH_LABEL_LBN 4
#define	ESF_HZ_EV_FLSH_LABEL_WIDTH 6
#define	ESF_HZ_EV_FLSH_FLUSH_TYPE_LBN 0
#define	ESF_HZ_EV_FLSH_FLUSH_TYPE_WIDTH 4
#define	ESE_HZ_XN_FLUSH_EVNT_STRUCT_SIZE 64

/*------------------------------------------------------------*/
/* ES_xn_mcdi_evnt */
#define	ESF_HZ_EV_MCDI_TYPE_LBN 60
#define	ESF_HZ_EV_MCDI_TYPE_WIDTH 4
#define	ESF_HZ_EV_MCDI_PHASE_LBN 59
#define	ESF_HZ_EV_MCDI_PHASE_WIDTH 1
#define	ESF_HZ_EV_MCDI_RSVD_LBN 52
#define	ESF_HZ_EV_MCDI_RSVD_WIDTH 7
#define	ESF_HZ_EV_MCDI_CODE_LBN 44
#define	ESF_HZ_EV_MCDI_CODE_WIDTH 8
#define	ESF_HZ_EV_MCDI_SRC_LBN 36
#define	ESF_HZ_EV_MCDI_SRC_WIDTH 8
#define	ESF_HZ_EV_MCDI_LEVEL_LBN 33
#define	ESF_HZ_EV_MCDI_LEVEL_WIDTH 3
#define	ESF_HZ_EV_MCDI_CONT_LBN 32
#define	ESF_HZ_EV_MCDI_CONT_WIDTH 1
#define	ESF_HZ_EV_MCDI_DATA_LBN 0
#define	ESF_HZ_EV_MCDI_DATA_WIDTH 32
#define	ESE_HZ_XN_MCDI_EVNT_STRUCT_SIZE 64

/*------------------------------------------------------------*/
/* ES_xn_rx_pkts */
#define	ESF_HZ_EV_RXPKTS_TYPE_LBN 60
#define	ESF_HZ_EV_RXPKTS_TYPE_WIDTH 4
#define	ESF_HZ_EV_RXPKTS_PHASE_LBN 59
#define	ESF_HZ_EV_RXPKTS_PHASE_WIDTH 1
#define	ESF_HZ_EV_RXPKTS_FLOW_LOOKUP_LBN 58
#define	ESF_HZ_EV_RXPKTS_FLOW_LOOKUP_WIDTH 1
#define	ESF_HZ_EV_RXPKTS_ROLLOVER_LBN 57
#define	ESF_HZ_EV_RXPKTS_ROLLOVER_WIDTH 1
#define	ESF_HZ_EV_RXPKTS_RSVD_LBN 22
#define	ESF_HZ_EV_RXPKTS_RSVD_WIDTH 35
#define	ESF_HZ_EV_RXPKTS_LABEL_LBN 16
#define	ESF_HZ_EV_RXPKTS_LABEL_WIDTH 6
#define	ESF_HZ_EV_RXPKTS_NUM_PACKETS_LBN 0
#define	ESF_HZ_EV_RXPKTS_NUM_PACKETS_WIDTH 16
#define	ESE_HZ_XN_RX_PKTS_STRUCT_SIZE 64

/*------------------------------------------------------------*/
/* ES_xn_rx_prefix */
#define	ESF_HZ_RX_PREFIX_TIMESTAMP_LBN 64
#define	ESF_HZ_RX_PREFIX_TIMESTAMP_WIDTH 64
#define	ESF_HZ_RX_PREFIX_USER_LBN 56
#define	ESF_HZ_RX_PREFIX_USER_WIDTH 8
#define	ESF_HZ_RX_PREFIX_FILTER_ID_LBN 46
#define	ESF_HZ_RX_PREFIX_FILTER_ID_WIDTH 10
#define	ESF_HZ_RX_PREFIX_TIMESTAMP_STATUS_LBN 44
#define	ESF_HZ_RX_PREFIX_TIMESTAMP_STATUS_WIDTH 2
#define	ESF_HZ_RX_PREFIX_SENTINEL_LBN 43
#define	ESF_HZ_RX_PREFIX_SENTINEL_WIDTH 1
#define	ESF_HZ_RX_PREFIX_ROLLOVER_LBN 42
#define	ESF_HZ_RX_PREFIX_ROLLOVER_WIDTH 1
#define	ESF_HZ_RX_PREFIX_L4_STATUS_LBN 41
#define	ESF_HZ_RX_PREFIX_L4_STATUS_WIDTH 1
#define	ESF_HZ_RX_PREFIX_L3_STATUS_LBN 40
#define	ESF_HZ_RX_PREFIX_L3_STATUS_WIDTH 1
#define	ESF_HZ_RX_PREFIX_L2_STATUS_LBN 38
#define	ESF_HZ_RX_PREFIX_L2_STATUS_WIDTH 2
#define	ESF_HZ_RX_PREFIX_L4_CLASS_LBN 36
#define	ESF_HZ_RX_PREFIX_L4_CLASS_WIDTH 2
#define	ESF_HZ_RX_PREFIX_L3_CLASS_LBN 34
#define	ESF_HZ_RX_PREFIX_L3_CLASS_WIDTH 2
#define	ESF_HZ_RX_PREFIX_L2_CLASS_LBN 32
#define	ESF_HZ_RX_PREFIX_L2_CLASS_WIDTH 2
#define	ESF_HZ_RX_PREFIX_CSUM_FRAME_LBN 16
#define	ESF_HZ_RX_PREFIX_CSUM_FRAME_WIDTH 16
#define	ESF_HZ_RX_PREFIX_NEXT_FRAME_LOC_LBN 14
#define	ESF_HZ_RX_PREFIX_NEXT_FRAME_LOC_WIDTH 2
#define	ESF_HZ_RX_PREFIX_LENGTH_LBN 0
#define	ESF_HZ_RX_PREFIX_LENGTH_WIDTH 14
#define	ESE_HZ_XN_RX_PREFIX_STRUCT_SIZE 128

/*------------------------------------------------------------*/
/* ES_xn_time_sync_evnt */
#define	ESF_HZ_EV_TSYNC_TYPE_LBN 60
#define	ESF_HZ_EV_TSYNC_TYPE_WIDTH 4
#define	ESF_HZ_EV_TSYNC_PHASE_LBN 59
#define	ESF_HZ_EV_TSYNC_PHASE_WIDTH 1
#define	ESF_HZ_EV_TSYNC_SUBTYPE_LBN 53
#define	ESF_HZ_EV_TSYNC_SUBTYPE_WIDTH 6
#define	ESF_HZ_EV_TSYNC_RSVD_LBN 50
#define	ESF_HZ_EV_TSYNC_RSVD_WIDTH 3
#define	ESF_HZ_EV_TSYNC_CLOCK_IS_SET_LBN 49
#define	ESF_HZ_EV_TSYNC_CLOCK_IS_SET_WIDTH 1
#define	ESF_HZ_EV_TSYNC_CLOCK_IN_SYNC_LBN 48
#define	ESF_HZ_EV_TSYNC_CLOCK_IN_SYNC_WIDTH 1
#define	ESF_HZ_EV_TSYNC_TIME_HIGH_48_LBN 0
#define	ESF_HZ_EV_TSYNC_TIME_HIGH_48_WIDTH 48
#define	ESE_HZ_XN_TIME_SYNC_EVNT_STRUCT_SIZE 64

/*------------------------------------------------------------*/
/* ES_xn_tx_cmplt */
#define	ESF_HZ_EV_TXCMPL_TYPE_LBN 60
#define	ESF_HZ_EV_TXCMPL_TYPE_WIDTH 4
#define	ESF_HZ_EV_TXCMPL_PHASE_LBN 59
#define	ESF_HZ_EV_TXCMPL_PHASE_WIDTH 1
#define	ESF_HZ_EV_TXCMPL_RSVD_LBN 56
#define	ESF_HZ_EV_TXCMPL_RSVD_WIDTH 3
#define	ESF_HZ_EV_TXCMPL_LABEL_LBN 50
#define	ESF_HZ_EV_TXCMPL_LABEL_WIDTH 6
#define	ESF_HZ_EV_TXCMPL_TIMESTAMP_STATUS_LBN 48
#define	ESF_HZ_EV_TXCMPL_TIMESTAMP_STATUS_WIDTH 2
#define	ESF_HZ_EV_TXCMPL_SEQUENCE_LBN 40
#define	ESF_HZ_EV_TXCMPL_SEQUENCE_WIDTH 8
#define	ESF_HZ_EV_TXCMPL_PARTIAL_TSTAMP_LBN 0
#define	ESF_HZ_EV_TXCMPL_PARTIAL_TSTAMP_WIDTH 40
#define	ESE_HZ_XN_TX_CMPLT_STRUCT_SIZE 64

/* Enum PCI_CONSTANTS */
#define	ESE_HZ_PCI_CONSTANTS_PCI_BASE_CONFIG_SPACE_SIZE 256
#define	ESE_HZ_PCI_CONSTANTS_PCI_EXPRESS_XCAP_HDR_SIZE 4

/* Enum VIRTIO_BLOCK_FEATURES */
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_WRITE_ZEROES 14
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_DISCARD 13
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_CONFIG_WCE 11
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_TOPOLOGY 10
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_FLUSH 9
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_BLK_SIZE 6
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_RO 5
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_GEOMETRY 4
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_SEG_MAX 2
#define	ESE_HZ_VIRTIO_BLOCK_FEATURES_VIRTIO_BLK_F_SIZE_MAX 1

/* Enum VIRTIO_COMMON_FEATURES */
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_NOTIFICATION_DATA 38
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_SR_IOV 37
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_ORDER_PLATFORM 36
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_IN_ORDER 35
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_RING_PACKED 34
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_ACCESS_PLATFORM 33
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_VERSION_1 32
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_RING_EVENT_IDX 29
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_RING_INDIRECT_DESC 28
#define	ESE_HZ_VIRTIO_COMMON_FEATURES_VIRTIO_CMN_F_ANY_LAYOUT 27

/* Enum VIRTIO_NET_FEATURES */
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_SPEED_DUPLEX 63
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_CTRL_MAC_ADDR 23
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_MQ 22
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_GUEST_ANNOUNCE 21
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_CTRL_VLAN 19
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_CTRL_RX 18
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_CTRL_VQ 17
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_STATUS 16
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_MRG_RXBUF 15
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_HOST_UFO 14
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_HOST_ECN 13
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_HOST_TSO6 12
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_HOST_TSO4 11
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_GUEST_UFO 10
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_GUEST_ECN 9
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_GUEST_TSO6 8
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_GUEST_TSO4 7
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_MAC 5
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_MTU 3
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_CTRL_GUEST_OFFLOADS 2
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_GUEST_CSUM 1
#define	ESE_HZ_VIRTIO_NET_FEATURES_VIRTIO_NET_F_CSUM 0

/* Enum X3_CTL_EVENT_REASON */
#define	ESE_HZ_X3_CTL_EVENT_REASON_HW_INTERNAL_PORTWIDE 0xA
#define	ESE_HZ_X3_CTL_EVENT_REASON_HW_INTERNAL 0x9
#define	ESE_HZ_X3_CTL_EVENT_REASON_CTPIO_BAD_FLAGS 0x8
#define	ESE_HZ_X3_CTL_EVENT_REASON_CTPIO_BAD_REORDERING 0x7
#define	ESE_HZ_X3_CTL_EVENT_REASON_CTPIO_FIFO_OVERFLOW 0x6
#define	ESE_HZ_X3_CTL_EVENT_REASON_CTPIO_ALIGN 0x5
#define	ESE_HZ_X3_CTL_EVENT_REASON_CTPIO_LEN 0x4
#define	ESE_HZ_X3_CTL_EVENT_REASON_RX_BAD_BUF_ADDR 0x3
#define	ESE_HZ_X3_CTL_EVENT_REASON_RX_FIFO_OVERFLOW 0x2
#define	ESE_HZ_X3_CTL_EVENT_REASON_RX_BAD_DISC 0x1
#define	ESE_HZ_X3_CTL_EVENT_REASON_MCDI 0x0

/* Enum X3_CTL_EVENT_SUBTYPE */
#define	ESE_HZ_X3_CTL_EVENT_SUBTYPE_FLUSH 0x2
#define	ESE_HZ_X3_CTL_EVENT_SUBTYPE_TIME_SYNC 0x1
#define	ESE_HZ_X3_CTL_EVENT_SUBTYPE_UNSOL_OVERFLOW 0x0

/* Enum X3_FILTER_ID */
#define	ESE_HZ_X3_FILTER_ID_NO_FILTER_MATCHED 0x3ff

/* Enum X3_L2_CLASS */
#define	ESE_HZ_X3_L2_CLASS_ETH_01VLAN 1
#define	ESE_HZ_X3_L2_CLASS_OTHER 0

/* Enum X3_L2_STATUS */
#define	ESE_HZ_X3_L2_STATUS_RESERVED 3
#define	ESE_HZ_X3_L2_STATUS_FCS_ERR 2
#define	ESE_HZ_X3_L2_STATUS_LEN_ERR 1
#define	ESE_HZ_X3_L2_STATUS_GOOD 0

/* Enum X3_L3_CLASS */
#define	ESE_HZ_X3_L3_CLASS_RESERVED 3
#define	ESE_HZ_X3_L3_CLASS_OTHER 2
#define	ESE_HZ_X3_L3_CLASS_IP6 1
#define	ESE_HZ_X3_L3_CLASS_IP4 0

/* Enum X3_L3_STATUS */
#define	ESE_HZ_X3_L3_STATUS_BAD_OR_UNKNOWN 1
#define	ESE_HZ_X3_L3_STATUS_GOOD 0

/* Enum X3_L4_CLASS */
#define	ESE_HZ_X3_L4_CLASS_OTHER 3
#define	ESE_HZ_X3_L4_CLASS_FRAGMENT 2
#define	ESE_HZ_X3_L4_CLASS_UDP 1
#define	ESE_HZ_X3_L4_CLASS_TCP 0

/* Enum X3_L4_STATUS */
#define	ESE_HZ_X3_L4_STATUS_BAD_OR_UNKNOWN 1
#define	ESE_HZ_X3_L4_STATUS_GOOD 0

/* Enum X3_TX_EVENT_TIMESTAMP_STATUS */
#define	ESE_HZ_X3_TX_EVENT_TIMESTAMP_STATUS_VALID 0x1
#define	ESE_HZ_X3_TX_EVENT_TIMESTAMP_STATUS_NOT_TAKEN 0x0

/* Enum XN_CT_THRESH */
#define	ESE_HZ_XN_CT_THRESH_CTPIO_DIS 0xff

/* Enum XN_EVENT_TYPE */
#define	ESE_HZ_XN_EVENT_TYPE_MCDI 0x4
#define	ESE_HZ_XN_EVENT_TYPE_CONTROL 0x3
#define	ESE_HZ_XN_EVENT_TYPE_TX_COMPLETION 0x1
#define	ESE_HZ_XN_EVENT_TYPE_RX_PKTS 0x0

/* Enum XN_NEXT_FRAME_LOC */
#define	ESE_HZ_XN_NEXT_FRAME_LOC_SEPARATELY 0x1
#define	ESE_HZ_XN_NEXT_FRAME_LOC_TOGETHER 0x0

/* XIL_CFGBAR_TBL_ENTRY */
#define	ESF_GZ_CFGBAR_CONT_CAP_OFF_HI_LBN 96
#define	ESF_GZ_CFGBAR_CONT_CAP_OFF_HI_WIDTH 32
#define	ESF_GZ_CFGBAR_CONT_CAP_OFFSET_LBN 68
#define	ESF_GZ_CFGBAR_CONT_CAP_OFFSET_WIDTH 60
#define	ESE_GZ_CONT_CAP_OFFSET_BYTES_SHIFT 4
#define	ESF_GZ_CFGBAR_CONT_CAP_OFF_LO_LBN 68
#define	ESF_GZ_CFGBAR_CONT_CAP_OFF_LO_WIDTH 28
#define	ESF_GZ_CFGBAR_CONT_CAP_RSV_LBN 67
#define	ESF_GZ_CFGBAR_CONT_CAP_RSV_WIDTH 1
#define	ESE_GZ_CFGBAR_EFCT_BAR_NUM_INVALID 7
#define	ESE_GZ_CFGBAR_EFCT_BAR_NUM_EXPANSION_ROM 6
#define	ESF_GZ_CFGBAR_CONT_CAP_BAR_LBN 64
#define	ESF_GZ_CFGBAR_CONT_CAP_BAR_WIDTH 3
#define	ESE_GZ_CFGBAR_CONT_CAP_BAR_NUM_INVALID 7
#define	ESE_GZ_CFGBAR_CONT_CAP_BAR_NUM_EXPANSION_ROM 6
#define	ESE_GZ_CFGBAR_ENTRY_SIZE_EFCT 24
#define	ESE_GZ_CFGBAR_ENTRY_HEADER_SIZE 8
#define	ESE_GZ_CFGBAR_ENTRY_REV_EFCT 0
#define	ESE_GZ_CFGBAR_ENTRY_LAST 0xfffff
#define	ESE_GZ_CFGBAR_ENTRY_CONT_CAP_ADDR 0xffffe
#define	ESE_GZ_CFGBAR_ENTRY_EFCT 0x1
#define	ESE_GZ_XIL_CFGBAR_TBL_ENTRY_STRUCT_SIZE 128

#define EFCT_VSEC_TABLE_ENTRY_OFFSET 0x10
#define EFCT_VSEC_ENTRY_PROJECT_ID_VAL 0x5833
#define EFCT_VSEC_ENTRY_TYPE_REV_VAL 0
#define EFCT_VSEC_ENTRY_TABLE_TYPE_VAL 0x20
/* XIL_CFGBAR_VSEC */
#define	ESF_GZ_VSEC_TBL_OFF_HI_LBN 64
#define	ESF_GZ_VSEC_TBL_OFF_HI_WIDTH 32
#define	ESE_GZ_VSEC_TBL_OFF_HI_BYTES_SHIFT 32
#define	ESF_GZ_VSEC_TBL_OFF_LO_LBN 36
#define	ESF_GZ_VSEC_TBL_OFF_LO_WIDTH 28
#define	ESE_GZ_VSEC_TBL_OFF_LO_BYTES_SHIFT 4
#define	ESF_GZ_VSEC_TBL_BAR_LBN 32
#define	ESF_GZ_VSEC_TBL_BAR_WIDTH 4
#define	ESE_GZ_VSEC_BAR_NUM_INVALID 7
#define	ESE_GZ_VSEC_BAR_NUM_EXPANSION_ROM 6
#define	ESE_GZ_VSEC_LEN_HIGH_OFFT 16
#define	ESE_GZ_VSEC_LEN_MIN 12
#define	ESE_GZ_VSEC_VER_XIL_CFGBAR 0
#define	ESE_GZ_XLNX_VSEC_ID 0x20
#define	ESE_GZ_XIL_CFGBAR_VSEC_STRUCT_SIZE 96

/* Enum DESIGN_PARAMS */
//Remove it once avaialble in efct_Reg.h
#define	ESE_EFCT_DP_GZ_NUM_FILTER 19
#define	ESE_EFCT_DP_GZ_EV_QUEUES 18
#define	ESE_EFCT_DP_GZ_EVQ_SIZES 17
#define	ESE_EFCT_DP_GZ_RX_MAX_RUNT 16
#define	ESE_EFCT_DP_GZ_RX_L4_CSUM_PROTOCOLS 15
#define	ESE_EFCT_DP_GZ_EVQ_UNSOL_CREDIT_SEQ_BITS 14
#define	ESE_EFCT_DP_GZ_PARTIAL_TSTAMP_SUB_NANO_BITS 13
#define	ESE_EFCT_DP_GZ_TX_PACKET_FIFO_SIZE 12
#define	ESE_EFCT_DP_GZ_TX_CTPIO_APERTURE_SIZE 11
#define	ESE_EFCT_DP_GZ_TX_MAXIMUM_REORDER 10
#define	ESE_EFCT_DP_GZ_RX_METADATA_LENGTH 9
#define	ESE_EFCT_DP_GZ_FRAME_OFFSET_FIXED 8
#define	ESE_EFCT_DP_GZ_RX_BUFFER_FIFO_SIZE 7
#define	ESE_EFCT_DP_GZ_TX_CTPIO_APERTURES 6
#define	ESE_EFCT_DP_GZ_RX_QUEUES 5
#define	ESE_EFCT_DP_GZ_RX_BUFFER_SIZE 4
#define	ESE_EFCT_DP_GZ_CTPIO_STRIDE 3
#define	ESE_EFCT_DP_GZ_EVQ_STRIDE 2
#define	ESE_EFCT_DP_GZ_RX_STRIDE 1
#define	ESE_EFCT_DP_GZ_PAD 0

#define	ESF_GZ_TX_SEND_ADDR_WIDTH 64

/* Enum XN_EVENT_TYPE */
#define	ESE_HZ_XN_EVENT_TYPE_DRIVER 0x5
#define	ESF_HZ_DRIVER_DATA_LBN 0
#define	ESF_HZ_DRIVER_DATA_WIDTH 59

#endif /* EFCT_REG_H */
