// SPDX-License-Identifier: GPL-2.0
/****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 **/

#define EFCT_IN_KCOMPAT_C 1

#include "kernel_compat.h"

#ifdef EFCT_USE_DEVLINK

#ifdef EFCT_NEED_DEVLINK_FLASH_UPDATE_TIMEOUT_NOTIFY
void devlink_flash_update_timeout_notify(struct devlink *devlink,
					 const char *status_msg,
					 const char *component,
					 unsigned long timeout)
{
	/* Treat as a status notification with no timeout indicated */
	devlink_flash_update_status_notify(devlink, status_msg, component, 0, 0);
}
#endif
#ifndef EFCT_HAVE_DEVLINK_DEVL_DRIVERINIT_SET_GET
int devl_param_driverinit_value_get(struct devlink *devlink, u32 param_id,
				    union devlink_param_value *val)
{
	return devlink_param_driverinit_value_get(devlink, param_id, val);
}

int devl_param_driverinit_value_set(struct devlink *devlink, u32 param_id,
				    union devlink_param_value val)
{
	return devlink_param_driverinit_value_set(devlink, param_id, val);
}
#endif
#ifndef EFCT_HAVE_DEVLINK_DEVL_API
int devl_port_register(struct devlink *devlink,
		       struct devlink_port *devlink_port,
		       unsigned int port_index)
{
	return devlink_port_register(devlink,
				     devlink_port,
				     port_index);
}

void devl_port_unregister(struct devlink_port *devlink_port)
{
	return devlink_port_unregister(devlink_port);
}
#endif
#else

static int efct_devlink_info_add(struct devlink_info_req *req,
				 const char *prefix, const char *name,
				const char *value)
{
	int offset = strlen(req->buf);

	scnprintf(&req->buf[offset], req->bufsize - offset, "%s%s: %s\n",
		  prefix, name, value);
	return 0;
}

int devlink_info_serial_number_put(struct devlink_info_req *req, const char *sn)
{
	return efct_devlink_info_add(req, "", "serial_number", sn);
}

int devlink_info_driver_name_put(struct devlink_info_req *req, const char *name)
{
	return efct_devlink_info_add(req, "", "driver", name);
}

int devlink_info_board_serial_number_put(struct devlink_info_req *req,
					 const char *bsn)
{
	return efct_devlink_info_add(req, "board.", "serial_number", bsn);
}

int devlink_info_version_fixed_put(struct devlink_info_req *req,
				   const char *version_name,
				   const char *version_value)
{
	return efct_devlink_info_add(req, "fixed.", version_name, version_value);
}

int devlink_info_version_stored_put(struct devlink_info_req *req,
				    const char *version_name,
				    const char *version_value)
{
	return efct_devlink_info_add(req, "stored.", version_name,
				    version_value);
}

int devlink_info_version_running_put(struct devlink_info_req *req,
				     const char *version_name,
				     const char *version_value)
{
	return efct_devlink_info_add(req, "running.", version_name,
				    version_value);
}

#endif	/* !EFCT_USE_DEVLINK */

#ifndef EFCT_HAVE_IPV4_MULTICAST
#ifndef EFCT_HAVE_ETHER_ADDR_EQUAL_MASKED
static inline bool ether_addr_equal_masked(const u8 *addr1, const u8 *addr2,
					   const u8 *mask)
{
	int i;

	for (i = 0; i < ETH_ALEN; i++) {
		if ((addr1[i] ^ addr2[i]) & mask[i])
			return false;
	}

	return true;
}
#endif

bool ether_addr_is_ipv4_mcast(const u8 *addr)
{
	u8 ipv4_mcast_addr[ETH_ALEN] = {0x01, 0x00, 0x5e, 0x00, 0x00, 0x00};
	u8 mask[ETH_ALEN] = {0xff, 0xff, 0xff, 0x80, 0x00, 0x00};

	return ether_addr_equal_masked(addr, ipv4_mcast_addr, mask);
}
#endif

/* Kernel backwards compatibility
 * This file provides functionality missing from earlier kernels.
 */
