#!/bin/bash -eu

######################################################################
#
# Driver for Xilinx network controllers and boards
# Copyright 2021 Xilinx Inc.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation, incorporated herein by reference.
#
######################################################################

me=$(basename "$0")

######################################################################
# Symbol definition map

function generate_kompat_symbols() {
    echo "
EFCT_NEED_KERNEL_ETHTOOL_TS_INFO		nsymbol	kernel_ethtool_ts_info	include/linux/ethtool.h
EFCT_NEED_SKB_FRAG_OFF           nsymbol skb_frag_off        include/linux/skbuff.h
EFCT_HAVE_NETDEV_XMIT_MORE   symbol  netdev_xmit_more    include/linux/netdevice.h
EFCT_NEED_BYTE_QUEUE_LIMITS      nsymbol netdev_tx_sent_queue    include/linux/netdevice.h
EFCT_HAVE_NET_DEVLINK_H			file				include/net/devlink.h
EFCT_HAVE_NDO_GET_DEVLINK	member	struct_net_device_ops	ndo_get_devlink_port	include/linux/netdevice.h
EFCT_HAVE_DEVLINK_INFO		symbol	devlink_info_version_running_put	include/net/devlink.h
EFCT_NEED_DEVLINK_INFO_BOARD_SERIAL_NUMBER_PUT	nsymbol	devlink_info_board_serial_number_put	include/net/devlink.h
EFCT_HAVE_DEVLINK_OPS_SUPPORTED_FLASH_UPDATE_PARAMS	member	struct_devlink_ops	supported_flash_update_params	include/net/devlink.h
EFCT_HAVE_DEVLINK_RELOAD_ACTION member struct_devlink_ops   reload_actions include/net/devlink.h
EFCT_HAVE_DEVLINK_RELOAD_DOWN member struct_devlink_ops     reload_down include/net/devlink.h
EFCT_HAVE_DEVLINK_ONLY_RELOAD member struct_devlink_ops reload include/net/devlink.h
EFCT_HAVE_DEVLINK_RELOAD_DOWN_NS       memtype struct_devlink_ops      reload_down include/net/devlink.h int (*)(struct devlink *, bool,  struct netlink_ext_ack *)
EFCT_HAVE_DEVLINK_RELOAD_DOWN_EXTACK  memtype struct_devlink_ops  reload_down include/net/devlink.h int (*)(struct devlink *devlink, struct netlink_ext_ack *extack)
EFCT_HAVE_DEVLINK_DEVL_API symbol devl_port_register include/net/devlink.h
EFCT_HAVE_DEVLINK_RELOAD_UP_EXTACK  memtype struct_devlink_ops  reload_up include/net/devlink.h int (*)(struct devlink *devlink, struct netlink_ext_ack *extack)
EFCT_HAVE_DEVLINK_SET_EXTACK  memtype struct_devlink_param  set include/net/devlink.h int (*)(struct devlink *devlink, u32 id, struct devlink_param_gset_ctx *ctx, struct netlink_ext_ack *extack)
EFCT_HAVE_DEVLINK_DEVL_API symbol devl_port_register include/net/devlink.h
EFCT_HAVE_DEVLINK_DEVL_DRIVERINIT_SET_GET symbol devl_param_driverinit_value_get include/net/devlink.h
EFCT_HAVE_DEVLINK_SET_FEATURES_RELOAD symbol devlink_set_features include/net/devlink.h
EFCT_HAVE_DEVLINK_RELOAD_ENABLE_DISABLE symbol devlink_reload_enable include/net/devlink.h
EFCT_HAVE_DEVLINK_FLASH_UPDATE_PARAMS	symbol devlink_flash_update_params	include/net/devlink.h
EFCT_HAVE_DEVLINK_FLASH_UPDATE_PARAMS_FW	member	struct_devlink_flash_update_params	fw	include/net/devlink.h
EFCT_HAVE_DEVLINK_FLASH_UPDATE_BEGIN_NOTIFY	symbol	devlink_flash_update_begin_notify	include/net/devlink.h
EFCT_NEED_DEVLINK_FLASH_UPDATE_TIMEOUT_NOTIFY	nsymbol	devlink_flash_update_timeout_notify	include/net/devlink.h
EFCT_HAVE_COALESCE_PARAMS                member struct_ethtool_ops supported_coalesce_params include/linux/ethtool.h
EFCT_HAVE_ETHTOOL_LINKSETTINGS   symbol  ethtool_link_ksettings  include/linux/ethtool.h
EFCT_NEED_ETHTOOL_FLASH_DEVICE		nsymbol devlink_compat_flash_update	include/net/devlink.h
EFCT_NEED_ETHTOOL_EROM_VERSION		member struct_ethtool_drvinfo erom_version	include/uapi/linux/ethtool.h
EFCT_HAVE_OLD_DEV_OPEN   symtype dev_open    include/linux/netdevice.h   int (struct net_device *)
EFCT_HAVE_RTC_TIME64   nsymbol rtc_time64_to_tm   include/linux/rtc.h
EFCT_HAVE_ETHTOOL_RESET member  struct_ethtool_ops reset include/linux/ethtool.h
EFCT_USE_ETHTOOL_OPS_EXT    symbol  ethtool_ops_ext     include/linux/ethtool.h
EFCT_HAVE_NETDEV_REGISTER_RH   symbol  register_netdevice_notifier_rh  include/linux/netdevice.h
EFCT_HAVE_NDO_TX_TIMEOUT_TXQUEUE memtype struct_net_device_ops   ndo_tx_timeout  include/linux/netdevice.h   void (*)(struct net_device *, unsigned int)
EFCT_HAVE_NDO_EXT_CHANGE_MTU     memtype struct_net_device_ops_extended  ndo_change_mtu  include/linux/netdevice.h       int (*)(struct net_device *, int)
EFCT_HAVE_PPM_TO_PPB		symbol	scaled_ppm_to_ppb	include/linux/ptp_clock_kernel.h
EFCT_HAVE_PTP_GETTIMEX64      member  struct_ptp_clock_info       gettimex64 include/linux/ptp_clock_kernel.h
EFCT_HAVE_NETDEV_MTU_LIMITS      member  struct_net_device       max_mtu include/linux/netdevice.h
EFCT_HAVE_NETDEV_EXT_MTU_LIMITS  member  struct_net_device_extended      max_mtu include/linux/netdevice.h
EFCT_HAVE_ETHTOOL_COALESCE_CQE		memtype	struct_ethtool_ops	get_coalesce	include/linux/ethtool.h	int (*)(struct net_device *, struct ethtool_coalesce *, struct kernel_ethtool_coalesce *, struct netlink_ext_ack *)
EFCT_HAVE_ETH_HW_ADDR_SET                symbol eth_hw_addr_set         include/linux/etherdevice.h
EFCT_HAVE_ETHTOOL_GET_RINGPARAM_EXTACK   memtype struct_ethtool_ops      get_ringparam   include/linux/ethtool.h void (*)(struct net_device *, struct ethtool_ringparam *, struct kernel_ethtool_ringparam *, struct netlink_ext_ack *)
EFCT_HAVE_ETHTOOL_SET_RINGPARAM_EXTACK   memtype struct_ethtool_ops      set_ringparam   include/linux/ethtool.h int (*)(struct net_device *, struct ethtool_ringparam *, struct kernel_ethtool_ringparam *, struct netlink_ext_ack *)
EFCT_HAVE_DEVLINK_ALLOC_DEV		symtype	devlink_alloc		include/net/devlink.h	struct devlink *(const struct devlink_ops *, size_t, struct device *)
EFCT_HAVE_DEVLINK_ALLOC_NS_DEV		symtype	devlink_alloc_ns	include/net/devlink.h	struct devlink *(const struct devlink_ops *,size_t, struct net *, struct device *)
EFCT_HAVE_VOID_DEVLINK_REGISTER		symtype	devlink_register	include/net/devlink.h	void(struct devlink *)
EFCT_HAVE_DEVLINK_PARAMS_PUBLISH		symtype	devlink_params_publish	include/net/devlink.h	void(struct devlink *)
EFCT_HAVE_DEVLINK_PARAMS_UNPUBLISH	symtype	devlink_params_unpublish include/net/devlink.h	void(struct devlink *)
EFCT_HAVE_NDO_GET_PHYS_PORT_ID           member  struct_net_device_ops   ndo_get_phys_port_id    include/linux/netdevice.h
EFCT_HAVE_NDO_GET_PHYS_PORT_NAME           member  struct_net_device_ops   ndo_get_phys_port_name    include/linux/netdevice.h
EFCT_HAVE_DEVLINK_PORT_ATTR     symtype   devlink_port_attrs_set  include/net/devlink.h       void (struct devlink_port *, struct devlink_port_attrs *)
EFCT_HAVE_DEVLINK_PORT_ATTR_CONST     symtype   devlink_port_attrs_set  include/net/devlink.h       void (struct devlink_port *, const struct devlink_port_attrs *)
EFCT_NEED_HWMON_T_ALARM				nsymbol	HWMON_T_ALARM		include/linux/hwmon.h
EFCT_HAVE_HWMON_READ_STRING		member	struct_hwmon_ops	read_string	include/linux/hwmon.h
EFCT_HAVE_HWMON_READ_STRING_CONST	memtype	struct_hwmon_ops	read_string	include/linux/hwmon.h	int(*)(struct device *, enum hwmon_sensor_types, u32, int, const char **)
EFCT_HAVE_PCI_FLR_RESET_PREPARE           member  struct_pci_error_handlers   reset_prepare    include/linux/pci.h
EFCT_HAVE_PCI_FLR_RESET_NOTIFY           member  struct_pci_error_handlers   reset_notify    include/linux/pci.h
EFCT_HAVE_NAPI_THREAD			member  struct_napi_struct  thread   include/linux/netdevice.h
EFCT_HAVE_NET_DEVICE_THREADED		member  struct_net_device  threaded   include/linux/netdevice.h
EFCT_HAVE_NET_DEVICE_PREFER_BUSY_POLL	symbol	napi_prefer_busy_poll	include/linux/netdevice.h
EFCT_HAVE_NDO_SIOCDEVPRIVATE		member  struct_net_device_ops  ndo_siocdevprivate   include/linux/netdevice.h
EFCT_HAVE_NDO_ETH_IOCTL		member  struct_net_device_ops  ndo_eth_ioctl   include/linux/netdevice.h
EFCT_HAVE_EEPROM_BY_PAGE                member struct_ethtool_ops get_module_eeprom_by_page include/linux/ethtool.h
EFCT_HAVE_SET_NETDEV_DEVLINK_PORT	symbol SET_NETDEV_DEVLINK_PORT	include/linux/netdevice.h
EFCT_HAVE_ETHER_ADDR_EQUAL_MASKED	symbol ether_addr_equal_masked  include/linux/etherdevice.h
EFCT_HAVE_IPV4_MULTICAST		symbol ether_addr_is_ipv4_mcast include/linux/etherdevice.h
EFCT_HAVE_INFO_DRIVER_NAME_PUT		symbol devlink_info_driver_name_put	include/net/devlink.h
EFCT_HAVE_KMAP_LOCAL_PAGE		symbol kmap_local_page	include/linux/highmem.h
EFX_NEED_TIMESPEC64_TO_NS_SIGNED	custom
EFCT_NAPI_ADD_WITH_BUDGET               symtype netif_napi_add include/linux/netdevice.h  void (struct net_device *, struct napi_struct *, int (*)(struct napi_struct *, int), int weight)
EFCT_NAPI_ADD_TX_WITHOUT_BUDGET		symbol  netif_napi_add_tx  include/linux/netdevice.h
EFCT_HAVE_IDA_ALLOC_RANGE		symbol	ida_alloc_range include/linux/idr.h
EFCT_HAVE_SEQ_SHOW_ATRIBUTE		symbol	DEFINE_SHOW_ATTRIBUTE include/linux/seq_file.h
EFCT_HAVE_DEBUG_LOOKUP_REMOVE		symbol	debugfs_lookup_and_remove include/linux/debugfs.h
EFCT_HAVE_ASSIGN_STR_NO_SRC_ARG		custom
" | egrep -v -e '^#' -e '^$' | sed 's/[ \t][ \t]*/:/g'
}

function do_EFX_NEED_TIMESPEC64_TO_NS_SIGNED

{
	test -f $KBUILD_SRC/include/linux/time64.h &&
	grep -q 'Prevent multiplication overflow ./' $KBUILD_SRC/include/linux/time64.h
}
function do_EFCT_HAVE_ASSIGN_STR_NO_SRC_ARG
{
	test -f $KBUILD_SRC/include/trace/stages/stage6_event_callback.h &&
	grep -q '#define __assign_str(dst)' $KBUILD_SRC/include/trace/stages/stage6_event_callback.h
}
TOPDIR=$(dirname "$0")/../../../..
source $TOPDIR/scripts/kernel_compat_funcs.sh
