/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#ifndef EFCT_MCDI_FUNCTIONS_H
#define EFCT_MCDI_FUNCTIONS_H

#include "efct_driver.h"
#include "efct_common.h"

int efct_mcdi_ev_init(struct efct_ev_queue *eventq);
int efct_mcdi_rx_init(struct efct_rx_queue *rx_queue);
int efct_mcdi_tx_init(struct efct_tx_queue *tx_queue);
int efct_mcdi_ev_fini(struct efct_ev_queue *eventq);
int efct_mcdi_ev_set_timer(struct efct_ev_queue *eventq, u32 ns, u32 mode, bool async);
int efct_mcdi_rx_fini(struct efct_rx_queue *rx_queue);
int efct_mcdi_tx_fini(struct efct_tx_queue *tx_queue);
int efct_mcdi_filter_insert(struct efct_nic *efct, struct efct_filter_spec *rule, u64 *handle);
int efct_mcdi_filter_remove(struct efct_nic *efct, u64 handle);
int efct_mcdi_filter_table_probe(struct efct_nic *efct);
void efct_mcdi_filter_table_remove(struct efct_nic *efct);
int efct_mcdi_nvram_update_start(struct efct_nic *efct, u32 type);
int efct_mcdi_nvram_write(struct efct_nic *efct, u32 type,
			  loff_t offset, const u8 *buffer, size_t length);
int efct_mcdi_nvram_erase(struct efct_nic *efct, u32 type,
			  loff_t offset, size_t length);
int efct_mcdi_nvram_metadata(struct efct_nic *efct, u32 type,
			     u32 *subtype, u16 version[4], char *desc,
			     size_t descsize);

int efct_mcdi_nvram_update_finish(struct efct_nic *efct, u32 type,
				  enum efct_update_finish_mode mode);
int efct_mcdi_nvram_update_finish_polled(struct efct_nic *efct, u32 type);
void efct_mcdi_print_fwver(struct efct_nic *efct, char *buf, size_t len);
#if !defined(EFCT_USE_KCOMPAT) || defined(EFCT_NEED_ETHTOOL_EROM_VERSION)
void efct_mcdi_erom_ver(struct efct_nic *efct, char *buf, size_t len);
#endif
#endif
