Xilinx EFCT Linux network driver
===================================
Version:  v1.6.9.0

Overview
--------
This package is the Linux NET driver source RPM/DEB for Xilinx X3 series adapters.

Supported hardware platforms
----------------------------
The drivers contained in this package support the following Xilinx
adapter:

- Xilinx X3522 card

Installation Prerequisite
--------------------------
Please install auxiliary RPM/DEB package if there is no in-tree auxiliary bus support before proceeding to install net driver.

Building and installation of RPM packages
-----------------------------------------

To build a binary RPM for the running kernel type:
  rpmbuild --rebuild <source rpm filename>

To install the resulting binary rpm:
  Locate the file that was created in the preceding step, prefixed with the
  annotation "Wrote:", usually it is in the <RPM top directory>/RPMS/
  then type:
    rpm -Uvh <binary rpm filename>

Building and installation of Debian packages
---------------------------------------------
To install a debian use:
	dpkg -i <debian package>

Loading and verifying Driver version
------------------------------------

To ensure that the correct version of the driver is loaded into the current kernel
   /sbin/modprobe -r xilinx_efct
   /sbin/modprobe xilinx_efct

Installation of the driver can be confirmed by typing:
   modinfo xilinx_efct | grep version
and checking for the line:
   version: v1.6.9.0

All network interfaces available on the system can be found with:
  ifconfig -a

Linux distribution support for Xilinx Adapters
--------------------------------------------------

This driver package is supported on:
 - Red Hat Enterprise Linux			8.6 - 8.10
 - Red Hat Enterprise Linux			9.4 - 9.7
 - Red Hat Enterprise Linux			10.0 - 10.1
 - Canonical Ubuntu Server LTS			22.04, 24.04
 - Debian 12 "Bookworm"
 - Linux kernels				5.11 - 6.18

Changelog
---------
### v1.6.9.0
Issue ON-17016:
 ~ Restrict update of EVQ type on tx_remove

### v1.6.8.0
Issue XNET-649:
 ~ Add module parameter to set max entries in RX ring

Issue XNET-648:
 ~ Do not report multicast_mismatch/other_host drop as drops in kernel

### v1.6.7.0
Issue XNET-642:
 ~ Add support kernel version 6.12.

### v1.6.6.0
Issue X3-1432:
 ~ Add support for IP proto based filters.

Issue X3-1432:
 ~ Add support for mac multicast mismatch filter for IP traffic.

Issue XNET-630:
 ~ Fix IRQ assignment via AUX interface.

### v1.6.3.0
Issue XNET-627:
 ~ Fix Suse rpm package to compile with auxiliary support.

### v1.6.1.0
Issue XNET-617:
 ~ Add support for 25G linkspeed.

Issue XNET-595:
 ~ Update net driver with limited system log by default.

Issue XNET-615:
 ~ Add ethtool support for MAC multicast filters.

Issue XNET-607:
 ~ Fix Suse packaging issues.

Issue XNET-606:
 ~ Reserve buffer space for 4 nested VLAN tags.

Issue XNET-592:
 ~ Remove unused PPS device and use PTP_EXTTS ioctl for PPS.

### v1.5.5.0
Issue XNET-558:
 ~ Fix nomenclature for binary rpm generated with correct verion string.

Issue XNET-561:
 ~ Fix for ethtool mod_info laser power output on RHEL 8.8 or later.

Issue X3-1380:
 ~ Drop packets reported as l2 len error in driver explicitly.

Issue XNET-547:
 ~ Fix out of bound array access in drop filter remove.

Issue XNET-564:
 ~ Nack unsupported filter request for TCP/UDP with VLAN ID.

Issue X3-1420:
 ~ Reduce time taken for PTP_SYS_OFFSET_PRECISE and clock_gettime().

Issue XNET-578:
 ~ Reduce time taken for ifconfig up for x3 interface.

Issue X3-1423:
 ~ Fix RPM installation issue on SLES 15.

### v1.5.2.0
Issue XNET-508:
 ~ Fix for EXTTS_REQUEST ioctl to use external PPS input.

Issue XNET-532:
 ~ Support for MAC/VLAN based filters using ethtool.

Issue XNET-486:
 ~ Support for up to 511 filters based on hardware availability.

Issue XNET-485:
 ~ Support for up to 16 receive queues based on hardware availability.

### v1.5.0.0
[General changes]
 ~ Minor improvements in PTP adjustment accuracy.

Issue ON-14479:
 ~ Exclusive queue can now be shared among filters from same client.

Issue XNET-509:
 ~ New AUX interface API to check validity/support for a given filter.

Issue XNET-475:
 ~ Fix possible deadlock in sensors state change event.

Issue XNET-194:
 ~ Add support for ETHER_FLOW ethtool filter type.

Issue XNET-510:
 ~ Avoid potential multicard enumeration failure.

Issue XNET-486:
 ~ Use variable number of filters based on hardware availability.

Issue XNET-485:
 ~ Use variable number of queues based on hardware availability.

### v1.3.1.0
[General changes]
 ~ fixes to support 5.18 upstream kernel
 ~ fixes checkpatch, cppcheck, sparse errors

Issue X3-1303
 ~ Allow reset scheduling in UP/DOWN nic state only. otherwise
   pci_reset_function() can deadlock if driver reset in probe state.

Issue X3-1273
 ~ Add PCI shutdown callback to clear hw resources during reboot

Issue XNET-461
 ~ Fix race in separate decrement and read operation

Issue ON-14533
 ~ Fix xilinx_efct refcount leak

Issue XNET-429
 ~ Change MSIX allocation scheme as per latest updates in 5.18 kernel.

Issue XNET-441
 ~ Fix return value for get_sset_count ethtool API.

### v1.2.5.0
Issue X3-1211
 ~ Use kernel API to copy mac addr to netdev->dev_addr

Issue X3-1211
 ~ Use DMA_BIDIRECTIONAL flag instead of PCI_DMA_BIDIRECTIONAL

### v1.2.4.0
Issue ON-14405
 ~ avoid races in huge page list update

### v1.2.3.0
Issue  XNET-422: Enable RX_CLS_LOC_SPECIAL for ethtool filter support
 ~ X3 driver supports special location values. ethtool command
   with explict filter will fail after this change.

Issue XNET-420
 ~ Set destination IP for multicast filter and update filter error
   reported in dmesg logs.

Issue XNET-414
 ~ Include base and limit index for tx queue in AUX interface

Issue X3-1176
 ~ Reset sync_events_state in ev_init

Issue X3-1034
 ~ Reading boot count from FCW to avoid MCDI timeout after MC reboot

Issue XNET-418
 ~ In case filter is matched and CONFIG_XILINX_AUX_EFCT=n, let stack handle
   received packets.

### v1.2.0.0
Issue XNET-271
 ~ Add support for ethtool selftests

Issue X3-1096
 ~ Replace "fw.usercfg" in devlink dev info output with fw.psid
   and include version only if it non zero and valid flag is set.

Issue X3-1042
 ~ FW sets IRQ moderation timer value in multiple of 1024 nanos.
   Use DIV_ROUND_CLOSEST to get more accurate value.

Issue XNET-402
 ~ Add ndo callback to read stats while holding lock.

Issue X3-1008
 ~ Rename pps stats variable

Issue X3-1028
 ~ Enable Interrupts after checking link state in net_open.

### v1.0.8.0
 ~ Initial version

Copyright
---------
Copyright 2021-2023 Xilinx Inc.
All rights reserved. Use is subject to license terms.
