################################################################################
#
# Driver for Xilinx network controllers and boards
# Copyright 2021 Xilinx Inc.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation, incorporated herein by reference.
#
################################################################################

%{!?disttag: %{expand: %%global disttag %%(. %%{_topdir}/SOURCES/xilinx-efct-disttag; echo -n $(xilinx_efct_disttag))}}
%{!?kernel:  %{expand: %%global kernel %%(uname -r)}}
%{!?kpath: %{expand: %%global kpath /lib/modules/%%{kernel}/build}}
%bcond_without kernel_header

%global suse    %(! [ "%{_vendor}" = "suse"   ] ; echo $?)

Name:           xilinx-efct
Version:        %{pkgversion}
Release:        1
Epoch:          0

Summary:        Xilinx X3 network adapter device driver

Group:          System Environment/Kernel
License:        GPLv2
URL:		http://www.xilinx.com/
Vendor:		Xilinx Inc

Source0:        %{name}-%{version}.tar.gz
Source1:        %{name}-disttag
Source2:        %{name}-suse.inc
Source3:        %{name}-redhat.inc

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
%description
The Linux kernel driver for Xilinx X3 Ethernet
controllers.

This builds a single RPM for a specific kernel version on any
supported Linux distribution.

%if %{suse}
%include %{_topdir}/SOURCES/%{name}-suse.inc
%else
%include %{_topdir}/SOURCES/%{name}-redhat.inc
%endif
