%define pkgversion 6.1.0.1009
################################################################################
#
# Driver for Solarflare network controllers and boards
# Copyright 2019 Solarflare Communications Inc.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation, incorporated herein by reference.
#
################################################################################

%{!?disttag: %global disttag %(. %{_topdir}/SOURCES/sfc-disttag; echo -n $(sfc_disttag))}
%{!?kernel:  %global kernel  %(uname -r)}
%{!?kpath:   %global kpath   /lib/modules/%%{kernel}/build}

%{!?sfc_config: %global sfc_config NDEBUG=1}
%{?sfc_minimal: %global sfc_config %{sfc_config} CONFIG_SFC_DEBUGFS= CONFIG_SFC_HWMON= CONFIG_SFC_I2C= CONFIG_SFC_MTD= CONFIG_SFC_SFE4001= CONFIG_SFC_PRIVATE_MDIO=y}

%global redhat  %(! [ "%{_vendor}" = "redhat" ] ; echo $?)
%global suse    %(! [ "%{_vendor}" = "suse"   ] ; echo $?)

Name:           sfc
Version:        %{pkgversion}
Release:        1
Epoch:          0

Summary:        Solarflare SFN5XXX|6XXX|7XXX|8XXX|X2 network adapter device driver

Group:          System Environment/Kernel
License:        GPLv2
URL:            http://www.solarflare.com/
Vendor:         Solarflare Communications

Source0:        %{name}-%{version}.tar.gz
Source1:        %{name}-disttag

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  binutils, gcc, make

%if %{suse}
%kernel_module_package -x debug -x trace
%endif

%description
The Linux kernel driver for Solarflare SFN5XXX|6XXX|7XXX|8XXX|X2 Ethernet
controllers.

This builds a single RPM for a specific kernel version on any
supported Linux distribution.

For a list of supported Solarflare products, please consult the release
notes and the user guide available from
https://www.xilinx.com/support/download/nic-software-and-drivers.html#drivers-software.

%define binary_name kernel-module-%{name}-%{disttag}-%{kernel}

%package -n %{binary_name}
Summary:        %{summary}
Group:          %{group}

%if !%{suse}
Provides:       %{name}-kmod-symvers = %{kernel}
%endif

%description -n %{binary_name}
The Linux kernel driver for Solarflare SFN5XXX|6XXX|7XXX|8XXX|X2 Ethernet
controllers.

For a list of supported Solarflare products, please consult the release
notes and the user guide available from
https://www.xilinx.com/support/download/nic-software-and-drivers.html#drivers-software.

# Inhibit debuginfo package
%define debug_package %{nil}

# -----------------------------------------------------------------------------

%prep
%setup -q

%if %{suse}
mkdir source
find . -maxdepth 1 -not -path . -not -name source -exec mv \{\} source/ \;
# This moves everything except the newly-created 'source' directory into the 'source' directory.

echo "sfc.ko external" > source/linux_net/drivers/net/ethernet/sfc/Module.supported
mkdir flavors
%endif

# -----------------------------------------------------------------------------

%build

[ -d "%{kpath}" ] || {
  set +x
  echo >&2 "ERROR: Kernel headers not found.  They should be at:"
  echo >&2 "ERROR:   %{kpath}"
%if %{redhat}
  echo >&2 "Hint: Install the $(echo '%{kernel}' | sed -r 's/(.*)(smp|hugemem|largesmp|PAE|xen)$/kernel-\2-devel-\1/; t; s/^/kernel-devel-/') package"
%endif
%if %{suse}
  echo >&2 "Hint: Install the kernel-source-$(echo '%{kernel}' | sed -r 's/-[^-]*$//') package"
%endif
  exit 1
}

%if %{suse}
export EXTRA_CFLAGS='-DVERSION="%version"'

for flavor in %flavors_to_build; do
  %{__rm} -rf "flavors/$flavor"
  # Files from previous package builds may have been left behind. They need to be removed.
  cp -r source "flavors/$flavor"
  %{__make} -C %{kernel_source $flavor} -j4 "KVER=%{kernel}" "KPATH=%{kpath}" %{sfc_config} CONFIG_SFC=m "M=$PWD/flavors/$flavor/linux_net/drivers/net/ethernet/sfc"
done
%else
cd $RPM_BUILD_DIR/%{name}-%{version}

# do the build
%{__make} -C linux_net -j4 "KVER=%{kernel}" "KPATH=%{kpath}" %{sfc_config} modules
%endif

# -----------------------------------------------------------------------------

%install

%{__rm} -rf "$RPM_BUILD_ROOT"
export INSTALL_MOD_PATH="$RPM_BUILD_ROOT"
export INSTALL_MOD_DIR=updates

cd "$RPM_BUILD_DIR/%{name}-%{version}"

# do the install
%if %{suse}
export EXTRA_CFLAGS='-DVERSION="%version"'
SOURCEBASE=source/

for flavor in %flavors_to_build; do
  %{__make} -C %{kernel_source $flavor} KVER=%{kernel} KPATH="%{kpath}" %{sfc_config} CONFIG_SFC=m "M=$PWD/flavors/$flavor/linux_net/drivers/net/ethernet/sfc" modules_install
done
%else
SOURCEBASE=

%{__make} -C linux_net KVER=%{kernel} KPATH="%{kpath}" %{sfc_config} modules_install
%endif

if [ -s "${SOURCEBASE}linux_net/drivers/net/ethernet/sfc/Module.symvers" ]; then
  # install fails when the file is empty, so don't do it.
  %{__install} -m 0644 "${SOURCEBASE}linux_net/drivers/net/ethernet/sfc/Module.symvers" \
    "${RPM_BUILD_ROOT}/lib/modules/%{kernel}/${INSTALL_MOD_DIR}/sfc.symvers"
fi

%{__install} -m 0644 "${SOURCEBASE}linux_net/drivers/net/ethernet/sfc/filter.h" \
  "${RPM_BUILD_ROOT}/lib/modules/%{kernel}/${INSTALL_MOD_DIR}/filter.h"
mkdir -p "${RPM_BUILD_ROOT}/lib/udev/rules.d"
%{__install} -m 0644 "${SOURCEBASE}udev/75-xilinx.rules" "${RPM_BUILD_ROOT}/lib/udev/rules.d/75-xilinx.rules"
mkdir -p "${RPM_BUILD_ROOT}/lib/sfc"
%{__install} -m 0755 "${SOURCEBASE}udev/produce-representor-name.sh" "${RPM_BUILD_ROOT}/lib/sfc/produce-representor-name.sh"
%{__install} -m 0755 "${SOURCEBASE}udev/trigger-representors.sh" "${RPM_BUILD_ROOT}/lib/sfc/trigger-representors.sh"

# rpm will complain about these files generated by depmod
rm -f ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/modules.*

# -----------------------------------------------------------------------------

%clean
%{__rm} -rf $RPM_BUILD_ROOT

# -----------------------------------------------------------------------------

%post -n %{binary_name}
/sbin/depmod -a %{kernel}
if [ "$(uname -r)" = "%{kernel}" ]; then
    if [ -x /etc/hotplug/pci.rc ]; then
        /etc/hotplug/pci.rc start >/dev/null
    fi
    modprobe sfc
fi
udevadm control --reload
true

%postun -n %{binary_name}
/sbin/depmod -a %{kernel}
true

# -----------------------------------------------------------------------------

%files -n %{binary_name}
%defattr(-,root,root,-)

%dir /lib/udev/rules.d/
%dir /lib/sfc/

/lib/modules/%{kernel}/*/*
/lib/udev/rules.d/75-xilinx.rules
/lib/sfc/produce-representor-name.sh
/lib/sfc/trigger-representors.sh
