%define pkgversion 8.3.3.1000
# Copyright 2019 Xilinx, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

Name:           sfutils
Version:        %{pkgversion}
Release:        1

Summary:        AMD Solarflare utilities for X2 and 8000 series NICs

Group:          System Environment
License:        Proprietary and Apache v2.0 and BSD-2-Clause-Patent
URL:            http://www.amd.com/
Vendor:         Advanced Micro Devices, Inc.

Source0:	sfutils-%{version}.tar.gz

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:	gettext
BuildRequires:	binutils, gcc, make

%description
This package provides Linux utilities for AMD Solarflare X2 and 8000 series NICs.
These utilities are 'sfboot' (boot settings), 'sfupdate' (firmware update)
and 'sfkey' (Appflex key management). For more details please refer to the
Solarflare Server Adapter User Guide SF-103837-CD.

%prep
%setup -q

%build
cd $RPM_BUILD_DIR/sfutils-%{version}
make

%install

%{__rm} -rf "$RPM_BUILD_ROOT"
%{__mkdir_p} ${RPM_BUILD_ROOT}/usr/sbin
%{__mkdir_p} ${RPM_BUILD_ROOT}/usr/share/sfutils
%{__mkdir_p} ${RPM_BUILD_ROOT}/usr/share/licenses/sfutils-%{version}

mv $RPM_BUILD_DIR/sfutils-%{version}/build/linux/tmp/sfupdate/sfupdate ${RPM_BUILD_ROOT}/usr/sbin/
mv $RPM_BUILD_DIR/sfutils-%{version}/build/linux/tmp/sfboot/sfboot ${RPM_BUILD_ROOT}/usr/sbin/
%ifnarch ppc64
mv $RPM_BUILD_DIR/sfutils-%{version}/build/linux/tmp/sfctool/sfctool ${RPM_BUILD_ROOT}/usr/sbin/
%endif
mv $RPM_BUILD_DIR/sfutils-%{version}/build/linux/tmp/sfkey/sfkey ${RPM_BUILD_ROOT}/usr/sbin/
mv $RPM_BUILD_DIR/sfutils-%{version}/sfupdate_images ${RPM_BUILD_ROOT}/usr/share/sfutils/
mv $RPM_BUILD_DIR/sfutils-%{version}/LICENSE ${RPM_BUILD_ROOT}/usr/share/licenses/sfutils-%{version}/

# There are no translations to copy at the moment

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(0644, root, root, 0755)
%attr(0711, root, root) /usr/sbin/sfupdate
%attr(0711, root, root) /usr/sbin/sfboot
%ifnarch ppc64
%attr(0711, root, root) /usr/sbin/sfctool
%endif
%attr(0711, root, root) /usr/sbin/sfkey
/usr/share/sfutils/
/usr/share/licenses/sfutils-%{version}/LICENSE
