'''
(c) Copyright 2012-2019 Xilinx, Inc. All rights reserved.

This file contains confidential and proprietary information
of Xilinx, Inc. and is protected under U.S. and
international copyright and other intellectual property
laws.

DISCLAIMER
This disclaimer is not a license and does not grant any
rights to the materials distributed herewith. Except as
otherwise provided in a valid license issued to you by
Xilinx, and to the maximum extent permitted by applicable
law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
(2) Xilinx shall not be liable (whether in contract or tort,
including negligence, or under any other theory of
liability) for any loss or damage of any kind or nature
related to, arising under or in connection with these
materials, including for any direct, or any indirect,
special, incidental, or consequential loss or damage
(including loss of data, profits, goodwill, or any type of
loss or damage suffered as a result of any action brought
by a third party) even if such damage or loss was
reasonably foreseeable or Xilinx had been advised of the
possibility of the same.

CRITICAL APPLICATIONS
Xilinx products are not designed or intended to be fail-
safe, or for use in any application requiring fail-safe
performance, such as life-support or safety devices or
systems, Class III medical devices, nuclear facilities,
applications related to the deployment of airbags, or any
other applications that could lead to death, personal
injury, or severe property or environmental damage
(individually and collectively, "Critical
Applications"). Customer assumes the sole risk and
liability of any use of Xilinx products in Critical
Applications, subject only to applicable laws and
regulations governing limitations on product liability.

THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
PART OF THIS FILE AT ALL TIMES
'''

import string


def stringify_table(rows):
    return [[str(f) for f in row] for row in rows]


def is_int(str):
    try:
        int(str)
        return True
    except:
        return False


def auto_justify_col(col, width):
    if min(map(is_int, col[1:])):
        # All fields (possibly excepting first) are integers.
        just = string.rjust
    else:
        just = string.ljust
    return [just(f, width) for f in col]


def justify_col_by_field(justify_field):
    def justify_col(col, width):
        return [justify_field(f, width) for f in col]
    return justify_col


def pad_table(rows, justify_field=None, justify_col=None, col_widths=None):
    if justify_field is None and justify_col is None:
        justify_col = auto_justify_col

    # This is like zip(*rows) except it handles non-uniform row lengths.
    ncols = max(len(row) for row in rows)
    cols = [[i<len(row) and row[i] or '' for row in rows] \
                for i in range(ncols)]

    widths = [max(len(f) for f in col) for col in cols]
    if col_widths:
        widths = map(max, widths, col_widths)
        for i, w in enumerate(widths):
            col_widths[i] = w

    if not justify_col:
        if hasattr(justify_field, '__getitem__'):
            justify_col = map(justify_col_by_field, justify_field)
        else:
            justify_col = justify_col_by_field(justify_field)
    if not hasattr(justify_col, '__getitem__'):
        justify_col = [justify_col] * ncols

    cols = [justify_col[i](col, widths[i]) for i, col in enumerate(cols)]
    return zip(*cols)


def fmt_table(rows, colsep=' ', rowsep='\n', pad=True, justify_field=None,
              justify_col=None, col_widths=None):
    rows = stringify_table(rows)
    if pad:
        rows = pad_table(rows, justify_field=justify_field,
                         justify_col=justify_col, col_widths=col_widths)
    return rowsep.join(colsep.join(row) for row in rows)


def playpen():
    test_data = [
        ['name',   'age', 'height'],
        ['david',   37, 180243],
        ['abbie',   38, 150242342],
        ['cameron', 5,  110],
        ]

    widths = [0] * 3
    print fmt_table(test_data, col_widths=widths)

    l = string.ljust
    r = string.rjust
    print fmt_table(test_data, col_widths=widths,
                    justify_field=[r, l, l], colsep=' | ')

#playpen()
