/*
** (c) Copyright 2012-2019 Xilinx, Inc. All rights reserved.
**
** This file contains confidential and proprietary information
** of Xilinx, Inc. and is protected under U.S. and
** international copyright and other intellectual property
** laws.
**
** DISCLAIMER
** This disclaimer is not a license and does not grant any
** rights to the materials distributed herewith. Except as
** otherwise provided in a valid license issued to you by
** Xilinx, and to the maximum extent permitted by applicable
** law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
** WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
** AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
** BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
** INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
** (2) Xilinx shall not be liable (whether in contract or tort,
** including negligence, or under any other theory of
** liability) for any loss or damage of any kind or nature
** related to, arising under or in connection with these
** materials, including for any direct, or any indirect,
** special, incidental, or consequential loss or damage
** (including loss of data, profits, goodwill, or any type of
** loss or damage suffered as a result of any action brought
** by a third party) even if such damage or loss was
** reasonably foreseeable or Xilinx had been advised of the
** possibility of the same.
**
** CRITICAL APPLICATIONS
** Xilinx products are not designed or intended to be fail-
** safe, or for use in any application requiring fail-safe
** performance, such as life-support or safety devices or
** systems, Class III medical devices, nuclear facilities,
** applications related to the deployment of airbags, or any
** other applications that could lead to death, personal
** injury, or severe property or environmental damage
** (individually and collectively, "Critical
** Applications"). Customer assumes the sole risk and
** liability of any use of Xilinx products in Critical
** Applications, subject only to applicable laws and
** regulations governing limitations on product liability.
**
** THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
** PART OF THIS FILE AT ALL TIMES
*/

/**
 * \file
 * \brief sc_arg: An argument to a node's initialisation function.
 */

#ifndef __SOLAR_CAPTURE_ARGS_H__
#define __SOLAR_CAPTURE_ARGS_H__

/**
 * \brief Possible parameter types that can be used for arguments in a node's
 * init function.
 */
enum sc_param_type {
  SC_PARAM_STR, /**< const char pointer (nul terminated) */
  SC_PARAM_INT, /**< signed 64 bit int */
  SC_PARAM_OBJ, /**< sc_object pointer */
  SC_PARAM_DBL, /**< native double type */
};


/**
 * \struct sc_arg
 * \brief Representation of an argument.  Used by node init functions.
 */
struct sc_arg {
  const char*        name; /**< Parameter name*/
  enum sc_param_type type; /**< Parameter type*/
  union {
    const char*             str;
    int64_t                 i;
    struct sc_object*       obj;
    double                  dbl;
  }                  val; /**< Parameter value */
};

/**
 * Function to construct a ::sc_arg struct of type ::SC_PARAM_INT
 * \param name       Name of argument.
 * \param val        Value of argument.
 * \return           The constructed ::sc_arg struct
 */
static inline struct sc_arg SC_ARG_INT(const char *name, int64_t val)
{
  struct sc_arg argument;
  argument.name = name;
  argument.type = SC_PARAM_INT;
  argument.val.i = val;
  return argument;
}

/**
 * Function to construct a ::sc_arg struct of type ::SC_PARAM_STR
 * \param name       Name of argument.
 * \param val        Value of argument.
 * \return           The constructed ::sc_arg struct
 */
static inline struct sc_arg SC_ARG_STR(const char *name, const char *val)
{
  struct sc_arg argument;
  argument.name = name;
  argument.type = SC_PARAM_STR;
  argument.val.str = val;
  return argument;
}

/**
 * Function to construct a ::sc_arg struct of type ::SC_PARAM_OBJ
 * \param name       Name of argument.
 * \param val        Value of argument.
 * \return           The constructed ::sc_arg struct
 */
static inline struct sc_arg SC_ARG_OBJ(const char *name, struct sc_object* val)
{
  struct sc_arg argument;
  argument.name = name;
  argument.type = SC_PARAM_OBJ;
  argument.val.obj = val;
  return argument;
}

/**
 * Function to construct a ::sc_arg struct of type ::SC_PARAM_DBL
 * \param name       Name of argument.
 * \param val        Value of argument.
 * \return           The constructed ::sc_arg struct
 */
static inline struct sc_arg SC_ARG_DBL(const char *name, double val)
{
  struct sc_arg argument;
  argument.name = name;
  argument.type = SC_PARAM_DBL;
  argument.val.dbl = val;
  return argument;
}


#endif  /* __SOLAR_CAPTURE_ARGS_H__ */

/** @}*/
