/*
** (c) Copyright 2012-2019 Xilinx, Inc. All rights reserved.
**
** This file contains confidential and proprietary information
** of Xilinx, Inc. and is protected under U.S. and
** international copyright and other intellectual property
** laws.
**
** DISCLAIMER
** This disclaimer is not a license and does not grant any
** rights to the materials distributed herewith. Except as
** otherwise provided in a valid license issued to you by
** Xilinx, and to the maximum extent permitted by applicable
** law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
** WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
** AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
** BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
** INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
** (2) Xilinx shall not be liable (whether in contract or tort,
** including negligence, or under any other theory of
** liability) for any loss or damage of any kind or nature
** related to, arising under or in connection with these
** materials, including for any direct, or any indirect,
** special, incidental, or consequential loss or damage
** (including loss of data, profits, goodwill, or any type of
** loss or damage suffered as a result of any action brought
** by a third party) even if such damage or loss was
** reasonably foreseeable or Xilinx had been advised of the
** possibility of the same.
**
** CRITICAL APPLICATIONS
** Xilinx products are not designed or intended to be fail-
** safe, or for use in any application requiring fail-safe
** performance, such as life-support or safety devices or
** systems, Class III medical devices, nuclear facilities,
** applications related to the deployment of airbags, or any
** other applications that could lead to death, personal
** injury, or severe property or environmental damage
** (individually and collectively, "Critical
** Applications"). Customer assumes the sole risk and
** liability of any use of Xilinx products in Critical
** Applications, subject only to applicable laws and
** regulations governing limitations on product liability.
**
** THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
** PART OF THIS FILE AT ALL TIMES
*/

/**
 * \file
 * \brief sc_object: Opaque object interface. Use this to pass all types of data
 * that are not ints, doubles or char arrays (see ::SC_PARAM_INT, ::SC_PARAM_DBL
 * and ::SC_PARAM_STR respectively for these).
 */

#ifndef __SOLAR_CAPTURE_OBJECT_H__
#define __SOLAR_CAPTURE_OBJECT_H__

/**
 * \brief The type of data the sc_object contains
 */
enum sc_object_type {
  SC_OBJ_ANY,
  SC_OBJ_OPAQUE,        /**< An opaque pointer */
  SC_OBJ_PKT_PREDICATE, /**< A packet predicate (see ::sc_pkt_predicate) */
  SC_OBJ_C_ATTR,        /**< Const attributes (see ::sc_attr) */
  SC_OBJ_NODE,          /**< A node (see ::sc_node) */
  SC_OBJ_POOL,          /**< A packet pool */
};

/**
 * \struct sc_object
 * \brief An opaque object. Use this to pass all types of data
 * that are not ints, doubles or char arrays (see ::SC_PARAM_INT, ::SC_PARAM_DBL
 * and ::SC_PARAM_STR respectively for these) to nodes.
 */
struct sc_object;

/**
 * \brief Return the type of data contained within the ::sc_object.
 * \param obj       The object to check the data type of.
 * \return          The type of data contained within the ::sc_object.
 */
extern enum sc_object_type sc_object_type(struct sc_object* obj);


#if SC_API_VER >= 2
/**
 * \brief Allocate memory for an opaque ::sc_object.
 *
 * \param obj_out   On success the allocated object.
 * \param opaque    A pointer to the data to be wrapped by the object.
 * \return          0 on success.
 */
extern int sc_opaque_alloc(struct sc_object** obj_out, void* opaque);

/**
 * \brief Free an ::sc_object previously allocated using ::sc_opaque_alloc. Only
 * use this to free an opaque ::sc_object. The underlying data wrapped by this
 * object will not be freed.
 * \param obj       The object to free
 */
extern void sc_opaque_free(struct sc_object* obj);

/**
 * \brief Set the opaque pointer in an ::sc_object
 * \param obj       The object to set the pointer on
 * \param opaque    The new opaque pointer to use
 */
extern void sc_opaque_set_ptr(struct sc_object* obj, void* opaque);

/**
 * \brief Get the opaque pointer stored in an ::sc_object
 * \param obj       The object to fetch the opaque pointer from.
 * \return          The opaque pointer.
 */
extern void* sc_opaque_get_ptr(const struct sc_object* obj);
#endif


#endif  /* __SOLAR_CAPTURE_OBJECT_H__ */
/** @} */
