/*
** (c) Copyright 2012-2019 Xilinx, Inc. All rights reserved.
**
** This file contains confidential and proprietary information
** of Xilinx, Inc. and is protected under U.S. and
** international copyright and other intellectual property
** laws.
**
** DISCLAIMER
** This disclaimer is not a license and does not grant any
** rights to the materials distributed herewith. Except as
** otherwise provided in a valid license issued to you by
** Xilinx, and to the maximum extent permitted by applicable
** law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
** WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
** AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
** BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
** INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
** (2) Xilinx shall not be liable (whether in contract or tort,
** including negligence, or under any other theory of
** liability) for any loss or damage of any kind or nature
** related to, arising under or in connection with these
** materials, including for any direct, or any indirect,
** special, incidental, or consequential loss or damage
** (including loss of data, profits, goodwill, or any type of
** loss or damage suffered as a result of any action brought
** by a third party) even if such damage or loss was
** reasonably foreseeable or Xilinx had been advised of the
** possibility of the same.
**
** CRITICAL APPLICATIONS
** Xilinx products are not designed or intended to be fail-
** safe, or for use in any application requiring fail-safe
** performance, such as life-support or safety devices or
** systems, Class III medical devices, nuclear facilities,
** applications related to the deployment of airbags, or any
** other applications that could lead to death, personal
** injury, or severe property or environmental damage
** (individually and collectively, "Critical
** Applications"). Customer assumes the sole risk and
** liability of any use of Xilinx products in Critical
** Applications, subject only to applicable laws and
** regulations governing limitations on product liability.
**
** THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
** PART OF THIS FILE AT ALL TIMES
*/

/**
 * \file
 * \brief Miscellaneous utility functions.
 */

#ifndef __SOLAR_CAPTURE_MISC_H__
#define __SOLAR_CAPTURE_MISC_H__


struct sc_session;


/**
 * \brief Join a multicast group.
 *
 * \param scs        A session
 * \param interface  The network interface to join on
 * \param group      The multicast group to join
 *
 * \return 0 on success, or a negative error code.
 *
 * This function joins multicast group @p group on interface @p interface.
 * This is needed when you need to use the IGMP protocol to arrange that
 * multicast packets are delivered to the adapter.
 */
extern int  sc_join_mcast_group(struct sc_session* scs, const char* interface,
                                const char* group);


#if SC_API_VER >= 1
/** \cond NODOC */
/* Do not call these functions directly.  They are used indirectly via
 * <solar_capture/declare_types.h>.
 */
extern void sc_montype_constant(struct sc_session*, const char*, int);
extern void sc_montype_struct(struct sc_session*, const char*);
extern void sc_montype_field(struct sc_session*, const char*, const char*,
                             const char*, const char*);
extern void sc_montype_struct_end(struct sc_session*);
extern void sc_montype_flush(struct sc_session*);
/** \endcond */
#endif


#endif  /* __SOLAR_CAPTURE_MISC_H__ */
/** @} */
