/*
** (c) Copyright 2012-2019 Xilinx, Inc. All rights reserved.
**
** This file contains confidential and proprietary information
** of Xilinx, Inc. and is protected under U.S. and
** international copyright and other intellectual property
** laws.
**
** DISCLAIMER
** This disclaimer is not a license and does not grant any
** rights to the materials distributed herewith. Except as
** otherwise provided in a valid license issued to you by
** Xilinx, and to the maximum extent permitted by applicable
** law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
** WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
** AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
** BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
** INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
** (2) Xilinx shall not be liable (whether in contract or tort,
** including negligence, or under any other theory of
** liability) for any loss or damage of any kind or nature
** related to, arising under or in connection with these
** materials, including for any direct, or any indirect,
** special, incidental, or consequential loss or damage
** (including loss of data, profits, goodwill, or any type of
** loss or damage suffered as a result of any action brought
** by a third party) even if such damage or loss was
** reasonably foreseeable or Xilinx had been advised of the
** possibility of the same.
**
** CRITICAL APPLICATIONS
** Xilinx products are not designed or intended to be fail-
** safe, or for use in any application requiring fail-safe
** performance, such as life-support or safety devices or
** systems, Class III medical devices, nuclear facilities,
** applications related to the deployment of airbags, or any
** other applications that could lead to death, personal
** injury, or severe property or environmental damage
** (individually and collectively, "Critical
** Applications"). Customer assumes the sole risk and
** liability of any use of Xilinx products in Critical
** Applications, subject only to applicable laws and
** regulations governing limitations on product liability.
**
** THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
** PART OF THIS FILE AT ALL TIMES
*/

/**
 * \file
 * \brief sc_pkt_predicate: Interface for testing properties of packets.
 */

#ifndef __SOLAR_CAPTURE_PREDICATE_H__
#define __SOLAR_CAPTURE_PREDICATE_H__


struct sc_pkt_predicate;
struct sc_packet;


/**
 * \brief A packet predicate test function. It should return 1 (true), or 0 (false).
 */
typedef int (sc_pkt_predicate_test_fn)(struct sc_pkt_predicate*,
                                       struct sc_packet*);

/**
 * \brief A packet predicate object
 *
 * This can be used with an \noderef{sc_filter} node to match packets for
 * filtering. 
 */
struct sc_pkt_predicate {
  sc_pkt_predicate_test_fn* pred_test_fn; /**< The predicate test function. It should return 1 (true) or 0 (false) */
  void*                     pred_private; /**< Field to hold state for the predicate function */
};
/*
 * Doxygen might output an error that references the line above, saying
 * "Member __attribute__ (variable) of file predicate.h is not documented".
 * This error can be ignored.
 */

/**
 * \brief Allocate a packet predicate object.
 *
 * \param pred_out        On success the allocated ::sc_pkt_predicate object.
 * \param private_bytes   Size of private memory area wanted.
 * \return                0 on success.
 *
 * Packet predicates are used to test packets against some criteria.  The
 * test function should return true (1) or false (0).
 *
 * If @p private_bytes is non-zero then @p pred_private is initialised with a
 * pointer to a region of memory of size @p private_bytes.  The @p pred_private
 * field may be used by the implementation to hold state.
 */
extern int sc_pkt_predicate_alloc(struct sc_pkt_predicate** pred_out,
                                  int private_bytes);

/**
 * \brief Convert a ::sc_pkt_predicate into a ::sc_object.
 *
 * \param pred            An ::sc_pkt_predicate instance or NULL
 * \return                NULL if @p pred is NULL otherwise the converted ::sc_object.
 */
extern struct sc_object*
  sc_pkt_predicate_to_object(struct sc_pkt_predicate* pred);

/**
 * \brief Convert a ::sc_object into a ::sc_pkt_predicate.
 *
 * \param obj             An ::sc_object instance or NULL
 * \return                NULL if @p obj is NULL otherwise the converted ::sc_pkt_predicate.
 */
extern struct sc_pkt_predicate*
  sc_pkt_predicate_from_object(struct sc_object* obj);


#endif  /* __SOLAR_CAPTURE_PREDICATE_H__ */
/** @} */
