
# (c) Copyright 2012-2019 Xilinx, Inc. All rights reserved.
#
# This file contains confidential and proprietary information
# of Xilinx, Inc. and is protected under U.S. and
# international copyright and other intellectual property
# laws.
#
# DISCLAIMER
# This disclaimer is not a license and does not grant any
# rights to the materials distributed herewith. Except as
# otherwise provided in a valid license issued to you by
# Xilinx, and to the maximum extent permitted by applicable
# law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
# WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
# AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
# BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
# INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
# (2) Xilinx shall not be liable (whether in contract or tort,
# including negligence, or under any other theory of
# liability) for any loss or damage of any kind or nature
# related to, arising under or in connection with these
# materials, including for any direct, or any indirect,
# special, incidental, or consequential loss or damage
# (including loss of data, profits, goodwill, or any type of
# loss or damage suffered as a result of any action brought
# by a third party) even if such damage or loss was
# reasonably foreseeable or Xilinx had been advised of the
# possibility of the same.
#
# CRITICAL APPLICATIONS
# Xilinx products are not designed or intended to be fail-
# safe, or for use in any application requiring fail-safe
# performance, such as life-support or safety devices or
# systems, Class III medical devices, nuclear facilities,
# applications related to the deployment of airbags, or any
# other applications that could lead to death, personal
# injury, or severe property or environmental damage
# (individually and collectively, "Critical
# Applications"). Customer assumes the sole risk and
# liability of any use of Xilinx products in Critical
# Applications, subject only to applicable laws and
# regulations governing limitations on product liability.
#
# THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
# PART OF THIS FILE AT ALL TIMES

# This is replaced by the export script
%define pkgversion 1.6.9.1

%{!?pkgrelease: %{expand: %%define pkgrelease 0}}

Name:           solar_capture-python
Version:        %(echo '%{pkgversion}' | sed 's/-/_/g')
Release:        %{pkgrelease}
Summary:        SolarCapture packet capture utility libraries
Group:          Applications/Internet
License:        Various
URL:            http://www.solarflare.com/
Vendor:         Solarflare
Source0:        %{name}-%{pkgversion}.tgz
BuildRoot:      %{_builddir}/%{name}-root
BuildRequires:  gcc make python2-devel
BuildRequires:  solar_capture-core = %{version}-%{release}
Requires:       solar_capture-core = %{version}-%{release}
Provides:       solar_capture-python = %{pkgversion}-%{release}

# Do not build debuginfo package
%define  debug_package %{nil}

%description
This package provides the python bindings and example applications for
SolarCapture, a high performance packet capture and processing utility
from Solarflare.

%prep
%setup -n %{name}-%{pkgversion}

%build
make -C src                                     \
    SC_INCLUDE=%{SC_INCLUDE}                    \
    SC_LIBRARY=%{SC_LIBRARY}                    \
    STRIP_LIBS=1                                \
    SC_RPM_BUILD=1                              \
    all_python

%install
make -C src                                     \
    SC_INCLUDE=%{SC_INCLUDE}                    \
    SC_LIBRARY=%{SC_LIBRARY}                    \
    STRIP_LIBS=1                                \
    SC_RPM_BUILD=1                              \
    BIN_DIR=%{_bindir}                          \
    DOC_DIR=%{_defaultdocdir}                   \
    PY_SITE_DIR=%{python2_sitelib}              \
    DESTDIR=$RPM_BUILD_ROOT                     \
    install_python

# Byte-compile the python before packaging
[ -x /usr/lib/rpm/brp-python-bytecompile ] && /usr/lib/rpm/brp-python-bytecompile

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/solar_*
%{python2_sitelib}/*
%{_defaultdocdir}/*
