<?xml version="1.0" encoding="utf-8"?>
<!-- Copyright 2020 Xilinx, Inc. All rights reserved.
Copyright 2017-2019 Solarflare Communications Inc.
Use is subject to license terms. -->
<instrumentationManifest xsi:schemaLocation="http://schemas.microsoft.com/win/2004/08/events eventman.xsd"
                         xmlns="http://schemas.microsoft.com/win/2004/08/events"
                         xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events"
                         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                         xmlns:xs="http://www.w3.org/2001/XMLSchema"
                         xmlns:trace="http://schemas.microsoft.com/win/2004/08/events/trace">
  <instrumentation>
    <events>
      <provider name="Solarflare-Network adapters-SFN driver"
                guid="{02234AA1-6A28-53BD-7454-DA8672CB421B}"
                symbol="SfnEventProvider"
                resourceFileName="%SystemRoot%\System32\Drivers\SFN.sys"
                messageFileName="%SystemRoot%\System32\Drivers\SFN.sys">
        <levels />
        <opcodes />
        <tasks />
        <keywords>
          <keyword mask="0x800000000000"
                   name="Diagnostics"
                   symbol="SfnDiagnosticsKeyword"
                   message="$(string.keyword.Diagnostics)" />
          <keyword mask="0x400000000000"
                   name="Configuration"
                   symbol="SfnConfigurationKeyword"
                   message="$(string.keyword.Configuration)" />
        </keywords>
        <channels>
          <!-- The order channels are defined here must be the same as in
           the EventProvider section of the .inf file. -->
          <channel name="Solarflare-Network adapters-SFN driver/Analytic"
                   chid="Analytic"
                   symbol="SfnAnalyticChannel"
                   type="Analytic"
                   enabled="false"
                   isolation="System"
                   message="$(string.channel.Analytic)" />
          <channel name="Solarflare-Network adapters-SFN driver/Operational"
                   chid="Operational"
                   symbol="SfnOperationalChannel"
                   type="Operational"
                   enabled="true"
                   isolation="System"
                   message="$(string.channel.Operational)" />
          <channel name="Solarflare-Network adapters-SFN driver/Debug"
                   chid="Debug"
                   symbol="SfnDebugChannel"
                   type="Debug"
                   enabled="false"
                   isolation="System"
                   message="$(string.channel.Debug)">
            <publishing>
              <level>4</level>
              <keywords>0xFFFFFFFFFFFF</keywords>
              <controlGuid>{447F3197-EB88-50BA-6350-B73824B7C524}</controlGuid>
            </publishing>
          </channel>
          <channel name="Solarflare-Network adapters-SFN driver/TraceLogging"
                   chid="TraceLogging"
                   symbol="SfnTraceLoggingChannel"
                   type="Debug"
                   enabled="false"
                   isolation="System"
                   message="$(string.channel.TraceLogging)">
            <publishing>
              <level>5</level>
              <keywords>0xFFFFFFFFFFFF</keywords>
              <controlGuid>{454B069F-452A-5A1F-5E87-AA4D8C896D8D}</controlGuid>
            </publishing>
          </channel>
        </channels>
        <templates>
          <template tid="template.NTSTATUS">
            <data name="Status"
                  inType="win:UInt32"
                  outType="win:NTSTATUS" />
          </template>
          <template tid="template.BistResult">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="Bist"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="Status"
                  inType="win:UInt32"
                  outType="win:HexInt32" />
            <data name="FaultCode"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
          </template>
          <template tid="template.DriverConfigurationType">
            <data name="KeywordName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="TypeRead"
                  inType="win:Int32"
                  outType="xs:int" />
            <data name="TypeExpected"
                  inType="win:Int32"
                  outType="xs:int" />
          </template>
          <template tid="template.DriverConfigurationUlong">
            <data name="KeywordName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="ValueRead"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="MinimumValue"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="MaximumValue"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="DefaultValue"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
          </template>

          <template tid="template.AdapterConfigurationLength">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="KeywordName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="LengthRead"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="LengthExpected"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
          </template>
          <template tid="template.AdapterConfigurationType">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="KeywordName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="TypeRead"
                  inType="win:Int32"
                  outType="xs:int" />
            <data name="TypeExpected"
                  inType="win:Int32"
                  outType="xs:int" />
          </template>
          <template tid="template.AdapterConfigurationNetworkAddress">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="KeywordName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="ValueRead"
                  inType="win:Binary" length="6"
                  outType="xs:hexBinary" />
            <data name="DefaultValue"
                  inType="win:Binary" length="6"
                  outType="xs:hexBinary" />
          </template>
          <template tid="template.AdapterConfigurationUlong">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="KeywordName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="ValueRead"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="MinimumValue"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="MaximumValue"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="DefaultValue"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
          </template>
          <template tid="template.AdapterConfigurationLinkSpeed">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="LinkSpeed"
                  inType="win:UInt64"
                  outType="xs:unsignedLong" />
            <data name="Duplex"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="Advertised"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="Supported"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
          </template>
          <template tid="template.AdapterConfigurationFec">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="Fec"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="Advertised"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="Supported"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
          </template>
          <template tid="template.AdapterConfigurationSetMtuFailed">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="Mtu"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
          </template>
          <template tid="template.AdapterSensor">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="SensorNumber"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="SensorName"
                  inType="win:AnsiString"
                  outType="xs:string" />
            <data name="SensorState"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="SensorValue"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="SensorUnit"
                  inType="win:AnsiString"
                  outType="xs:string" />
            <data name="SensorLowWarningLimit"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="SensorHighWarningLimit"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="SensorLowCriticalLimit"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
            <data name="SensorHighCriticalLimit"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
          </template>
          <template tid="template.DmaAdapterSynchronousCallbackNotSet">
            <data name="AdapterName"
                  inType="win:UnicodeString"
                  outType="xs:string" />
            <data name="DmaAdapterInfoFlags"
                  inType="win:UInt32"
                  outType="xs:unsignedInt" />
          </template>
        </templates>
        <events>
          <event value="1000" version="0"
                 symbol="Load"
                 channel="Analytic"
                 keywords="Diagnostics"
                 level="win:Informational"
                 task="win:None"
                 opcode="win:Start"
                 template="template.NTSTATUS"
                 message="$(string.event.Load)" />
          <event value="1001" version="0"
                 symbol="Unload" channel="Analytic"
                 keywords="Diagnostics"
                 level="win:Informational"
                 task="win:None"
                 opcode="win:Stop"
                 template="template.NTSTATUS"
                 message="$(string.event.Unload)" />
          <event value="1002" version="0"
                 symbol="BistResult"
                 channel="Operational"
                 keywords="Diagnostics"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.BistResult"
                 message="$(string.event.BistResult)" />
          <event value="1003" version="0"
                 symbol="BistSummary"
                 channel="Operational"
                 keywords="Diagnostics"
                 level="win:Informational"
                 task="win:None"
                 opcode="win:Info"
                 template="template.BistResult"
                 message="$(string.event.BistSummary)" />
          <event value="1004" version="0"
                 symbol="DriverConfigurationUlongIncorrectType"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.DriverConfigurationType"
                 message="$(string.event.DriverConfigurationIncorrectType)" />
          <event value="1005" version="0"
                 symbol="DriverConfigurationUlongOutOfRange"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.DriverConfigurationUlong"
                 message="$(string.event.DriverConfigurationOutOfRange)" />
          <event value="1006" version="0"
                 symbol="DriverConfigurationUlong"
                 channel="Analytic"
                 keywords="Configuration"
                 level="win:Informational"
                 task="win:None"
                 opcode="win:Info"
                 template="template.DriverConfigurationUlong"
                 message="$(string.event.DriverConfigurationUlong)" />

          <event value="2000" version="0"
                 symbol="AdapterConfigurationUlongIncorrectType"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationType"
                 message="$(string.event.AdapterConfigurationIncorrectType)" />
          <event value="2001" version="0"
                 symbol="AdapterConfigurationUlongOutOfRange"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationUlong"
                 message="$(string.event.AdapterConfigurationOutOfRange)" />
          <event value="2002" version="0"
                 symbol="AdapterConfigurationUlong"
                 channel="Analytic"
                 keywords="Configuration"
                 level="win:Informational"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationUlong"
                 message="$(string.event.AdapterConfigurationUlong)" />
          <event value="2003" version="0"
                 symbol="AdapterConfigurationNetworkAddressIncorrectLength"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationLength"
                 message="$(string.event.AdapterConfigurationNetworkAddressIncorrectLength)" />
          <event value="2004" version="0"
                 symbol="AdapterConfigurationNetworkAddressInvalid"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationNetworkAddress"
                 message="$(string.event.AdapterConfigurationNetworkAddressInvalid)" />
          <event value="2005" version="0"
                 symbol="AdapterConfigurationNetworkAddressNotLocallyAdministered"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationNetworkAddress"
                 message="$(string.event.AdapterConfigurationNetworkAddressNotLocallyAdministered)" />
          <event value="2006" version="0"
                 symbol="AdapterConfigurationNetworkAddress"
                 channel="Analytic"
                 keywords="Configuration"
                 level="win:Informational"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationNetworkAddress"
                 message="$(string.event.AdapterConfigurationNetworkAddress)" />
          <event value="2007" version="0"
                 symbol="AdapterConfigurationLinkSpeedNotSupported"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationLinkSpeed"
                 message="$(string.event.AdapterConfigurationLinkSpeedNotSupported)" />
          <event value="2008" version="0"
                 symbol="AdapterConfigurationFecNotSupported"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationFec"
                 message="$(string.event.AdapterConfigurationFecNotSupported)" />
          <event value="2009" version="0"
                 symbol="AdapterConfigurationSetMtuFailed"
                 channel="Operational"
                 keywords="Configuration"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterConfigurationSetMtuFailed"
                 message="$(string.event.AdapterConfigurationSetMtuFailed)" />

          <event value="3000" version="0"
                 symbol="AdapterSensorNormal"
                 channel="Operational"
                 keywords="Diagnostics"
                 level="win:Informational"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterSensor"
                 message="$(string.event.AdapterSensorNormal)" />

          <event value="3001" version="0"
                 symbol="AdapterSensorWarning"
                 channel="Operational"
                 keywords="Diagnostics"
                 level="win:Warning"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterSensor"
                 message="$(string.event.AdapterSensorWarning)" />

          <event value="3002" version="0"
                 symbol="AdapterSensorCritical"
                 channel="Operational"
                 keywords="Diagnostics"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterSensor"
                 message="$(string.event.AdapterSensorCritical)" />

          <event value="3003" version="0"
                 symbol="AdapterSensorBroken"
                 channel="Operational"
                 keywords="Diagnostics"
                 level="win:Error"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterSensor"
                 message="$(string.event.AdapterSensorBroken)" />

          <event value="3004" version="0"
                 symbol="AdapterSensorNoReading"
                 channel="Operational"
                 keywords="Diagnostics"
                 level="win:Informational"
                 task="win:None"
                 opcode="win:Info"
                 template="template.AdapterSensor"
                 message="$(string.event.AdapterSensorNoReading)" />

          <event value="4000" version="0"
                 symbol="DmaAdapterSynchronousCallbackNotSet"
                 channel="Operational"
                 keywords="Diagnostics"
                 level="win:Warning"
                 task="win:None"
                 opcode="win:Info"
                 template="template.DmaAdapterSynchronousCallbackNotSet"
                 message="$(string.event.DmaAdapterSynchronousCallbackNotSet)" />
        </events>
      </provider>
    </events>
  </instrumentation>
  <localization>
    <resources culture="en-US">
      <stringTable>
        <string id="level.LogAlways"
                value="Log Always" />
        <string id="level.Critical"
                value="Critical" />
        <string id="level.Error"
                value="Error" />
        <string id="level.Warning"
                value="Warning" />
        <string id="level.Informational"
                value="Information" />
        <string id="level.Verbose"
                value="Verbose" />

        <string id="opcode.Info"
                value="Info" />
        <string id="opcode.Start"
                value="Start" />
        <string id="opcode.Stop"
                value="Stop" />
        <string id="opcode.DCStart"
                value="DCStart" />
        <string id="opcode.DCStop"
                value="DCStop" />
        <string id="opcode.Extension"
                value="Extension" />
        <string id="opcode.Reply"
                value="Reply" />
        <string id="opcode.Resume"
                value="Resume" />
        <string id="opcode.Suspend"
                value="Suspend" />
        <string id="opcode.Send"
                value="Send" />
        <string id="opcode.Receive"
                value="Receive" />

        <string id="task.None"
                value="None"/>

        <string id="keyword.Diagnostics"
                value="Diagnostics" />
        <string id="keyword.Configuration"
                value="Configuration" />

        <string id="channel.Analytic"
                value="Analytic" />
        <string id="channel.Debug"
                value="Debug" />
        <string id="channel.Operational"
                value="Operational" />
        <string id="channel.TraceLogging"
                value="TraceLogging" />

        <string id="event.Unload"
                value="Driver unloaded" />
        <string id="event.Load"
                value="Driver loaded with status %1" />

        <string id="event.BistResult"
                value="%1 : BIST %2 error: %3, fault code: %4" />
        <string id="event.BistSummary"
                value="%1 : BIST mask %2 completed with status %3" />

        <string id="event.DriverConfigurationIncorrectType"
                value="SFN : The driver's %1 configuration parameter is not of the required type. Using default value." />
        <string id="event.DriverConfigurationOutOfRange"
                value="SFN : The driver's %1 configuration parameter is out of range. Using default value." />
        <string id="event.DriverConfigurationUlong"
                value="SFN : Configuration - %1 = %2." />

        <string id="event.AdapterConfigurationIncorrectType"
                value="%1 : The adapter's %2 configuration parameter is not of the required type. Using default value." />
        <string id="event.AdapterConfigurationOutOfRange"
                value="%1 : The adapter's %2 configuration parameter is out of range. Using default value." />
        <string id="event.AdapterConfigurationUlong"
                value="%1 : Configuration - %2 = %3." />
        <string id="event.AdapterConfigurationNetworkAddressIncorrectLength"
                value="%1 : The adapter's %2 configuration parameter is not of the required length. Using default value." />
        <string id="event.AdapterConfigurationNetworkAddressInvalid"
                value="%1 : The adapter's %2 configuration parameter is not a valid unicast/individual Ethernet network address. Using default value." />
        <string id="event.AdapterConfigurationNetworkAddressNotLocallyAdministered"
                value="%1 : The adapter's %2 configuration parameter is not a locally administered Ethernet network address. Using default value." />
        <string id="event.AdapterConfigurationNetworkAddress"
                value="%1 : Configuration - %2 = %3." />
        <string id="event.AdapterConfigurationLinkSpeedNotSupported"
                value="%1 : The adapter's link speed configuration parameter is not supported. Link speed: %2 Duplex: %3." />
        <string id="event.AdapterConfigurationFecNotSupported"
                value="%1 : The adapter's FEC configuration parameter is not supported. FEC: %2." />
        <string id="event.AdapterConfigurationSetMtuFailed"
                value="%1 : Failed to set the MTU to %2. If NIC Partitioning is in use, this can occur if the driver starts on an unprivileged function before it has started on the privileged function. Ensure the driver on the privileged function has been started at least once before the driver is started on the unprivileged function, or alternatively grant the unprivileged function the Link privilege so that it is permitted to set the MTU." />
        <string id="event.AdapterSensorNormal"
                value="%1 : Sensor %2 is now within normal limits." />
        <string id="event.AdapterSensorWarning"
                value="%1 : Sensor %2 warning: value outside normal limits." />
        <string id="event.AdapterSensorCritical"
                value="%1 : Sensor %2 error: value outside normal and warning limits." />
        <string id="event.AdapterSensorBroken"
                value="%1 : Sensor %2 error: sensor broken." />
        <string id="event.AdapterSensorNoReading"
                value="%1 : Sensor %2: sensor has no reading." />
        <string id="event.DmaAdapterSynchronousCallbackNotSet"
                value="%1 : DMA mappings may not complete synchronously." />
      </stringTable>
    </resources>
  </localization>
</instrumentationManifest>
