%define pkgversion 4.12.1.1021
%{!?disttag: %{expand: %%define disttag %%(. %%{_topdir}/SOURCES/sfc-disttag; echo -n $(sfc_disttag))}}
%{!?kernel:  %{expand: %%define kernel %%(uname -r)}}
%{!?kpath: %{expand: %%define kpath /lib/modules/%%{kernel}/build}}

%{!?sfc_config: %{expand: %%define sfc_config NDEBUG=1}}
%{?sfc_minimal: %{expand: %%define sfc_config %{sfc_config} CONFIG_SFC_DEBUGFS= CONFIG_SFC_HWMON= CONFIG_SFC_I2C= CONFIG_SFC_MTD= CONFIG_SFC_SFE4001= CONFIG_SFC_PRIVATE_MDIO=y}}

%define redhat     %(! [ "%{_vendor}" = "redhat" ] ; echo $?)
%define suse       %(! [ "%{_vendor}" = "suse"   ] ; echo $?)

Name:           sfc
Version:        %{pkgversion}
Release:        1
Epoch:          0

Summary:        Solarflare SFN5XXX|6XXX|7XXX|8XXX network adapter device driver

Group:          System Environment/Kernel
License:        GPL
URL:            http://www.solarflare.com/
Vendor:		Solarflare Communications

Source0:        %{name}-%{version}.tar.gz
Source1:        %{name}-disttag

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  binutils, gcc, make

%description
The Linux kernel driver for Solarflare SFC9000-family 10G/40G Ethernet
controllers.

This builds a single RPM for a specific kernel version on any
supported Linux distribution.

For a list of supported Solarflare products, please consult the release
notes and the user guide available from https://support.solarflare.com/.

%define binary_name kernel-module-%{name}-%{disttag}-%{kernel}
	
%package -n %{binary_name}
Summary:        %{summary}
Group:          %{group}
Provides:       %{name}-kmod-symvers = %{kernel}

%description -n %{binary_name}
The Linux kernel driver for Solarflare SFC4000 and SFC9000-family 10G/40G
Ethernet controllers.

For a list of supported Solarflare products, please consult the release
notes and the user guide available from https://support.solarflare.com/.

# Inhibit debuginfo package
%define debug_package %{nil}

# -----------------------------------------------------------------------------

%prep
%setup -q

# -----------------------------------------------------------------------------

%build

%if %{suse}
  krel="kernel-"$(uname -r | awk -F'-' '{print $3;}')
  (rpm -qi $krel 2>&1 > /dev/null) && (rpm --verify $krel || echo >&2 -e "\n\nWARNING: /boot/sym* might not be for this kernel. This may cause ksym dependancy errors on RPM install\n\n")
%endif

[ -d "%{kpath}" ] || {
  set +x
  echo >&2 "ERROR: Kernel headers not found.  They should be at:"
  echo >&2 "ERROR:   %{kpath}"
%if %{redhat}
  echo >&2 "Hint: Install the $(echo '%{kernel}' | sed -r 's/(.*)(smp|hugemem|largesmp|PAE|xen)$/kernel-\2-devel-\1/; t; s/^/kernel-devel-/') package"
%endif
%if %{suse}
  echo >&2 "Hint: Install the kernel-source-$(echo '%kernel}' | sed -r 's/-[^-]*$//') package"
%endif
  exit 1
}

cd $RPM_BUILD_DIR/%{name}-%{version}

# do the build
%{__make} -C linux_net -j4 KVER=%{kernel} KPATH="%{kpath}" %{sfc_config} modules

# -----------------------------------------------------------------------------

%install

%{__rm} -rf "$RPM_BUILD_ROOT"
cd "$RPM_BUILD_DIR/%{name}-%{version}"

# do the install
%{__make} -C linux_net INSTALL_MOD_PATH="${RPM_BUILD_ROOT}" INSTALL_MOD_DIR="updates" \
  KVER=%{kernel} KPATH="%{kpath}" %{sfc_config} modules_install
%{__install} -m 0644 linux_net/Module.symvers \
  ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/updates/sfc.symvers
%{__install} -m 0644 linux_net/driverlink_api.h \
  ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/updates/driverlink_api.h
%{__install} -m 0644 linux_net/filter.h \
  ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/updates/filter.h

# rpm will complain about these files generated by depmod
rm -f ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/modules.*

# -----------------------------------------------------------------------------

%clean
%{__rm} -rf $RPM_BUILD_ROOT

# -----------------------------------------------------------------------------

%post -n %{binary_name}
/sbin/depmod -a %{kernel}
if [ "$(uname -r)" = "%{kernel}" ]; then
    if [ -x /etc/hotplug/pci.rc ]; then
        /etc/hotplug/pci.rc start >/dev/null
    fi
    modprobe sfc
fi
true

%preun -n %{binary_name}
[ "$(uname -r)" = "%{kernel}" ] && \
  rmmod sfc &>/dev/null
true

%postun -n %{binary_name}
/sbin/depmod -a %{kernel}
true

# -----------------------------------------------------------------------------

%files -n %{binary_name}
%defattr(-,root,root,-)

/lib/modules/%{kernel}/*/*
