%define pkgversion 6.5.0.1003
Name:           sfutils
Version:        %{pkgversion}
Release:        1

Summary:        Solarflare Solarstorm SFC4000/SFC9000-family network controller utilities

Group:          System Environment
License:        Proprietary
URL:            http://www.solarflare.com/
Vendor:		Solarflare Communications

Source0:	sfutils-%{version}.tar.gz

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:	gettext
BuildRequires:	binutils, gcc, make

%description
This package provides the Linux boot and update utilities for the
Solarflare Communications SFC4000, SFC9000 and SFC9100 family 10G/40G Ethernet
controllers.

It also provides the 'sfctool' utility for controlling some driver tuning
features that would otherwise require a new kernel and ethtool utility.

The 'sfkey' utility manages maintenance keys for Solarflare SFA6902F
ApplicationOnload(tm) Engine network adapters. Maintenance keys activate
specific AOE applications to run on a particular network adapter.

%prep
%setup -q

%build
cd $RPM_BUILD_DIR/sfutils-%{version}
make

%install

%{__rm} -rf "$RPM_BUILD_ROOT"
%{__mkdir_p} ${RPM_BUILD_ROOT}/usr/sbin

mv $RPM_BUILD_DIR/sfutils-%{version}/build/linux/tmp/sfupdate/sfupdate ${RPM_BUILD_ROOT}/usr/sbin/
mv $RPM_BUILD_DIR/sfutils-%{version}/build/linux/tmp/sfboot/sfboot ${RPM_BUILD_ROOT}/usr/sbin/
mv $RPM_BUILD_DIR/sfutils-%{version}/build/linux/tmp/sfctool/sfctool ${RPM_BUILD_ROOT}/usr/sbin/
mv $RPM_BUILD_DIR/sfutils-%{version}/build/linux/tmp/sfkey/sfkey ${RPM_BUILD_ROOT}/usr/sbin/

# There are no translations to copy at the moment

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%attr(0711, root, root) /usr/sbin/sfupdate
%attr(0711, root, root) /usr/sbin/sfboot
%attr(0711, root, root) /usr/sbin/sfctool
%attr(0711, root, root) /usr/sbin/sfkey
