/* SPDX-License-Identifier: LGPL-2.1 */
/* X-SPDX-Copyright-Text: (c) Solarflare Communications Inc */

/*
 * \author  slp
 *  \brief  Falcon specific definitions
 *   \date  2004/08
 */

#ifndef __EF_VI_FALCON_H__
#define __EF_VI_FALCON_H__    

#define EFHW_4K		0x00001000u
#define EFHW_8K		0x00002000u

/* include the autogenerated register definitions */

#include "falcon_hw_defs.h"
#include "ef_vi_falcon_desc.h"
#include "ef_vi_falcon_event.h"


/*----------------------------------------------------------------------------
 *
 * Buffer virtual addresses (4K buffers) 
 *
 *---------------------------------------------------------------------------*/

/* Form a buffer virtual address from buffer ID and offset.  If the offset
** is larger than the buffer size, then the buffer indexed will be
** calculated appropriately.  It is the responsibility of the caller to
** ensure that they have valid buffers programmed at that address.
*/
#define EFVI_FALCON_VADDR_4K_S   	(12)	     
#define EFVI_FALCON_VADDR_M       0xfffff		/* post shift mask  */


#define EFVI_FALCON_BUFFER_4K_ADDR(id,off)      \
  (((id) << EFVI_FALCON_VADDR_4K_S) + (off))

#define EFVI_FALCON_BUFFER_4K_PAGE(vaddr)                       \
  (((vaddr) >> EFVI_FALCON_VADDR_4K_S) & EFVI_FALCON_VADDR_M)

#define EFVI_FALCON_BUFFER_4K_OFF(vaddr)                \
  ((vaddr) & __EFVI_MASK32(EFVI_FALCON_VADDR_4K_S))


/*----------------------------------------------------------------------------
 *
 * Timers
 *
 *---------------------------------------------------------------------------*/

#define EFVI_FALCON_AB_EVQTIMER_HOLD     (FFE_AB_TIMER_MODE_TRIG_START << FRF_AB_TIMER_MODE_LBN)
#define EFVI_FALCON_AB_EVQTIMER_RUN      (FFE_AB_TIMER_MODE_IMMED_START  << FRF_AB_TIMER_MODE_LBN)
#define EFVI_FALCON_AB_EVQTIMER_DISABLE  (FFE_AB_TIMER_MODE_DIS  << FRF_AB_TIMER_MODE_LBN) 

#define EFVI_FALCON_CZ_EVQTIMER_HOLD     (FFE_CZ_TIMER_MODE_TRIG_START << FRF_CZ_TIMER_MODE_LBN)
#define EFVI_FALCON_CZ_EVQTIMER_RUN      (FFE_CZ_TIMER_MODE_IMMED_START  << FRF_CZ_TIMER_MODE_LBN)
#define EFVI_FALCON_CZ_EVQTIMER_DISABLE  (FFE_CZ_TIMER_MODE_DIS  << FRF_CZ_TIMER_MODE_LBN) 


/* ---- ef_vi_event helpers --- */

#define EFVI_FALCON_EVENT_CODE(evp)             \
  ((evp)->u64 & EFVI_FALCON_EVENT_CODE_MASK)

#define EFVI_FALCON_EVENT_SW_DATA_MASK    0x0000ffff

#define __EFVI_FALCON_OPEN_MASK(WIDTH)  ((((uint64_t)1) << (WIDTH)) - 1)

#define EFVI_FALCON_EVENT_CODE_MASK                             \
  (__EFVI_FALCON_OPEN_MASK(EV_CODE_WIDTH) << EV_CODE_LBN)


#endif  /* __EF_VI_FALCON_H__ */
