# SPDX-License-Identifier: GPL-2.0 OR Solarflare-Binary
# X-SPDX-Copyright-Text: (c) Solarflare Communications Inc
TARGET		:= $(CPLANE_LIB)
MMAKE_TYPE	:= LIB

LIB_SRCS	:= mib.c mib_fwd.c services.c onload.c version.c
LIB_OBJS	:= $(LIB_SRCS:%.c=$(MMAKE_OBJ_PREFIX)%.o)

ALL		:= $(TARGET)


ifndef MMAKE_NO_RULES

all: $(ALL)

lib: $(TARGET)

clean:
	@$(MakeClean)

$(TARGET): $(LIB_OBJS)
	$(MMakeLinkStaticLib)

endif

######################################################################
# Autogenerated header for checking user/kernel consistency.
#
_CP_INTF_HDRS	:= cplane/cplane.h cplane/mib.h cplane/server.h \
	cplane/ioctl.h cplane/mmap.h cplane/mibdump_sock.h

CP_INTF_HDRS	:= $(_CP_INTF_HDRS:%=$(SRCPATH)/include/%)

ifdef MMAKE_USE_KBUILD
objd	:= $(obj)/
else
objd	:=
endif

$(objd)cp_intf_ver.h: $(CP_INTF_HDRS)
	@echo "  GENERATE $@"
	@md5=$$(cat $(CP_INTF_HDRS) | md5sum | sed 's/ .*//'); \
	echo "#define OO_CP_INTF_VER  \"$$md5\"" >"$@"

$(objd)$(MMAKE_OBJ_PREFIX)version.o: $(objd)cp_intf_ver.h

######################################################
# linux kbuild support
#
ifdef MMAKE_USE_KBUILD

lib_obj = cplane_lib.o
lib_obj_path = $(BUILDPATH)/lib/cplane

lib_obj_cmd = $(LD) -r $(LIB_SRCS:%.c=%.o) -o $(lib_obj)
all:
	$(MAKE) $(MMAKE_KBUILD_ARGS) KBUILD_BUILTIN=1 KBUILD_EXTMOD=$(lib_obj_path)
	$(lib_obj_cmd)
	echo "cmd_$(lib_obj_path)/$(lib_obj) := $(lib_obj_cmd)" > .$(lib_obj).cmd
clean:
	@$(MakeClean)
	rm -f cp_intf_ver.h cplane_lib.o
endif

ifdef MMAKE_IN_KBUILD
LIB_OBJS := $(LIB_SRCS:%.c=%.o)
obj-y    := $(LIB_OBJS)
endif

