/* SPDX-License-Identifier: GPL-2.0 OR BSD-2-Clause */
/* X-SPDX-Copyright-Text: (c) Copyright 2019-2020 Xilinx, Inc. */

#ifndef __CI_DRIVER_EFAB_HARDWARE_EF100_H__
#define __CI_DRIVER_EFAB_HARDWARE_EF100_H__

#include <ci/driver/efab/hardware/host_ef100_common.h>
#include <ci/driver/efab/hardware/ef100_vaddr.h>

/* FIXME: this header isn't autogenerated */
#define __EF100_OPEN_MASK(WIDTH)  ((((uint64_t)1) << (WIDTH)) - 1)
#define EF100_EVENT_CODE_MASK \
       (__EF100_OPEN_MASK(ESF_GZ_E_TYPE_WIDTH) << ESF_GZ_E_TYPE_LBN)
#define EF100_EVENT_CODE(evp)          (le64_to_cpu((evp)->u64) & EF100_EVENT_CODE_MASK)

#define EF100_EVENT_CODE_SW    ((uint64_t)ESE_GZ_EF100_EV_MCDI << ESF_GZ_E_TYPE_LBN)

#define EF100_EVENT_SW_SUBCODE_MASK \
       (__EF100_OPEN_MASK(MCDI_EVENT_CODE_WIDTH) << MCDI_EVENT_CODE_LBN)

#define EF100_EVENT_SW_SUBCODE(evp) \
       ((le64_to_cpu((evp)->u64) & EF100_EVENT_SW_SUBCODE_MASK) >> \
        MCDI_EVENT_CODE_LBN)

#define EF100_EVENT_TX_FLUSH_Q_ID_MASK \
	(__EF100_OPEN_MASK(MCDI_EVENT_TX_FLUSH_TXQ_WIDTH) << \
	 MCDI_EVENT_TX_FLUSH_TXQ_LBN)
#define EF100_EVENT_RX_FLUSH_Q_ID_MASK \
	(__EF100_OPEN_MASK(MCDI_EVENT_RX_FLUSH_RXQ_WIDTH) << \
	 MCDI_EVENT_RX_FLUSH_RXQ_LBN)

#define EF100_EVENT_TX_FLUSH_Q_ID(evp) \
	((le64_to_cpu((evp)->u64) & EF100_EVENT_TX_FLUSH_Q_ID_MASK) >> \
	 MCDI_EVENT_TX_FLUSH_TXQ_LBN)
#define EF100_EVENT_RX_FLUSH_Q_ID(evp) \
	((le64_to_cpu((evp)->u64) & EF100_EVENT_RX_FLUSH_Q_ID_MASK) >> \
	 MCDI_EVENT_RX_FLUSH_RXQ_LBN)

#define EF100_P_CTR_AP_BAR	2
#define EF100_DMA_TX_DESC_BYTES	16
#define EF100_DMA_RX_DESC_BYTES	8

/*! returns an address within a bar of the TX DMA doorbell */
static inline uint ef100_tx_dma_page_addr(uint vi_stride, uint dmaq_idx)
{
    return ER_GZ_TX_RING_DOORBELL + (dmaq_idx * vi_stride);
}

/*! returns an address within a bar of the RX DMA doorbell */
static inline uint ef100_rx_dma_page_addr(uint vi_stride, uint dmaq_idx)
{
    return ER_GZ_RX_RING_DOORBELL + (dmaq_idx * vi_stride);
}

/*! "page"=NIC-dependent register set size */
#define EF100_DMA_PAGE_MASK  (EFHW_4K-1)

/*! returns an address within a bar of the start of the "page"
    containing the TX DMA doorbell */
static inline int ef100_tx_dma_page_base(uint vi_stride, uint dma_idx)
{
	return ef100_tx_dma_page_addr(vi_stride, dma_idx) & ~EF100_DMA_PAGE_MASK;
}

/*! returns an address within a bar of the start of the "page"
    containing the RX DMA doorbell */
static inline int ef100_rx_dma_page_base(uint vi_stride, uint dma_idx)
{
	return ef100_rx_dma_page_addr(vi_stride, dma_idx) & ~EF100_DMA_PAGE_MASK;
}

/*! returns an offset within a "page" of the TX DMA doorbell */
static inline int ef100_tx_dma_page_offset(uint vi_stride, uint dma_idx)
{
	return ef100_tx_dma_page_addr(vi_stride, dma_idx) & EF100_DMA_PAGE_MASK;
}

/*! returns an offset within a "page" of the RX DMA doorbell */
static inline int ef100_rx_dma_page_offset(uint vi_stride, uint dma_idx)
{
	return ef100_rx_dma_page_addr(vi_stride, dma_idx) & EF100_DMA_PAGE_MASK;
}

#endif /* __CI_DRIVER_EFAB_HARDWARE_EF100_H__ */
